/*---------------------------------------------------------------
	FILE: CTicTac.h
	USE: Defines a high-performance stopwatch

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CTICTAC_H
#define  CTICTAC_H


/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{

	/** This class implements a high-performance stopwatch.Typical resolution
	 *   is about 1e-6 seconds.
	 */
	class CTicTac
	{
	private:
		void	**largeInts;
	public:
		/** Default constructor.
		 */
		CTicTac();

		/** Destructor.
		 */
		virtual ~CTicTac();

		/** Starts the stopwatch
		 * \sa Tac
		 */
		void	Tic();

		/** Stops the stopwatch
		 * \return Returns the ellapsed time in seconds.
		 * \sa Tic
		 */
		double	Tac();

	}; // End of class def.

} // End of namespace

#endif
