/*---------------------------------------------------------------
	FILE: CMemoryStream.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CMEMORYSTREAM_H
#define  CMEMORYSTREAM_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/CStream.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This CStream derived class allow using a memory buffer as a CStream.
	 *  This class is useful for storing any required set of variables or objects,
	 *   and then read them to other objects, or storing them to a file, for example.
	 *
	 * \sa CStream
	 */
	class CMemoryStream : public CStream
	{
	protected:
		 /** Method responsible for reading from the stream.
		 */
		unsigned int  Read(void *Buffer, unsigned int Count);

		/** Method responsible for writing to the stream.
		 *  Write attempts to write up to Count bytes to Buffer, and returns the number of bytes actually written.
		 */
		unsigned int  Write(const void *Buffer, unsigned int Count);

	private:
		/** Internal data
		 */
		void			*FMemory;
		unsigned int	FSize, FPosition,FBytesWritten;

		/** Resizes the internal buffer size.
		 */
		void resize(unsigned long newSize);
	public:
		/** Default constructor
		 */
		CMemoryStream();

		/** Destructor
		 */
		virtual ~CMemoryStream();

		/** Clears the memory buffer.
		 */
		void  Clear();

		/** Change size. This would be rarely used. Use ">>" operators for writing to stream.
		 * \sa Stream
		 */
		void  changeSize( unsigned long newSize );

		/** Method for moving to a specified position in the streamed resource.
		 *  \sa CStream::Seek
		 */
		unsigned long  Seek(long Offset, CStream::TSeekOrigin Origin = sFromBeginning);

		/** Returns the total size of the internal buffer.
		 */
		unsigned long  getTotalBytesCount();

		/** Method for getting the current cursor position, where 0 is the first byte and TotalBytesCount-1 the last one.
		 */
		unsigned long  getPosition();

		/** Method for getting a pointer to the raw stored data.
		 * The lenght in bytes is given by getTotalBytesCount
		 */
		void*  getRawBufferData();

	}; // End of class def.

} // End of namespace

#endif
