/*---------------------------------------------------------------
	FILE: CDebugOutputCapable.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CDebugOutputCapable_H
#define  CDebugOutputCapable_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/CStdOutStream.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This base class is used just for grouping purposes and for providing a common debug text output.
	 */
	class CDebugOutputCapable
	{
	public:

		/** Default initialization:
		  */
		CDebugOutputCapable()
		{
			debugOut = &UTILS::stdOut;
		}

		/** This can be used to output debug messages: default output is the console (through the UTILS::stdOut object), but users can implements any other output, i.e. for GUI applications.
		  * \sa ExampleXXX (TO DO...)
		  */
		CStream		*debugOut;

	}; // End of class def.

} // End of namespace

#endif
