Format info: [FF200704]
ICE Module: 
[InterfazCORBA]
Description:
	CompactStr(1377)
		496e74657266617a434f5242412053494d554c41444f522044452053454e410a
		2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d
		2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d0a
		0a45737465206d6f64756c6f20696d706c656d656e746120756e2073696d756c
		61646f7220646520726f626f74206d6f76696c2e204573746f20696e636c7579
		6520656c206d6f76696d69656e746f200a79206c61206f646f6d657472*ffed612e
		20457374*ffe120686563686f20646520666f726d6120717565207469656e652065
		6c206d69736d6f20696e74657266617a2071756520656c206d6f64756c6f2064
		65200a6d6f76696d69656e746f2079206f646f6d657472*ffed61207265616c2022
		496e74657266617a434f524241222e20200a0a456c2073696d756c61646f7220
		696e636c7579652063616d62696f73206465206c61732076656c6f6369646164
		657320636f6e2066696c74726f207061736f2062616a6f206465207072696d65
		72206f7264656e2c200a636f6e206c617320636f6e7374616e74657320646520
		7469656d706f206f6274656e69646173206578706572696d656e74616c6d656e
		74652064656c20726f626f74207265616c2e0a0a2d2d204a4c42432031382d4e
		4f562d323030353a205375626f206c6120756c74696d612076657273696f6e20
		636f6e206c6f732063616d62696f733a0a20202020202d20456c207369737465
		6d6120646520636f6f7264656e6164617320796120657320656c202265737461
		6e646172222c2065732064656369722c20656c20726f626f74206176616e7a61
		20686163696120656c20656a6520580a2020202020202020706f73697469766f
		206375616e646f207375206f7269656e746163696f6e206573206365726f2e20
		4c61206a757374696669636163696f6e2065732c206164656d61732064652068
		616365726c6f20636f6d6f200a20202020202020207061726563652071756520
		6c6f20686163656e206c61206d61796f72*ffed612c20717565206173*ffed20736520
		70756564656e2075736172206d6174726963657320686f6d6f67656e65617320
		70617261206c617320636f6f7264656e6164617320334420646972656374616d
		656e74650a202020202020202073696e206d6f64696669636172206e6164612e
		0a20202020202d20506172612065766974617220636f6e667573696f6e65732c
		2068652063616d626961646f206c6f73206e6f6d627265206465206c6f732073
		6572766963696f732c20646520666f726d6120717565200a2020202020202020
		206f626c69676f2061206c6f73206d6f64756c6f7320612074656e657220656e
		206375656e7461206c6f732063616d62696f732c20706f727175652073696e6f
		206461726120756e206572726f7220616c20616363656465720a202020202020
		2020206120736572766963696f7320717565206e6f206578697374656e2e0a0a
		2d2d204a4c42432031332d4d41592d323030353a200a20202020202d20496d70
		6c656d656e746f20656c206d65746f646f206465202247697261722220792061
		*fff161646920656c206e7565766f202247697261725f426c6f717565616e746522
		2e200a2020202020202020204573746520756c74696d6f20657374612070656e
		6469656e74652064652061*fff161646972736520616c20696e74657266617a2063
		6f726261207265616c2c20706f72207065746963696f6e20646520646f732061
		6c756d6e6f73206465205046432e0a20202020202d20486520656c696d696e61
		646f20746f646f73206c6f7320736572766963696f7320717565206e6f206573
		74616e20696d706c656d656e7461646f732c20706f7220636c6172696461642e
		0a
	EndCompactStr
Linked to the object: []
Includes (2) objects.
Included object #0 (SGr) :
	Group of Services: 
	[<Default group>]
	Description:
		CompactStr(103)
			477275706f20706f72206465666563746f3a0a0a4171756920657374616e206c
			61206d61796f726961206465206c61732066756e63696f6e657320696d706f72
			74616e746573207061726120636f6e74726f6c617220656c20726f626f742073
			696d756c61646f
		EndCompactStr
	Linked to the object: [InterfazCORBA]
	Includes (12) objects.
	Included object #0 (Srv) :
		Service: 
		[CambiarV]
		Description:
			CompactStr(199)
				4e4f4d4252453a2043616d6269617256656c6f63696461640a444553433a2043
				616d626961206c612076656c6f6369646164206c696e65616c2064656c20726f
				626f742e20456c2063616d62696f206e6f2073652070726f6475636972*ffe12069
				6e7374616e74616e65616d656e74650a504152414d4554524f5320494e3a200a
				666c6f617420765f6d7073203a2056656c6f6369646164206c696e65616c2065
				6e206d6574726f73202f20736567756e646f0a504152414d4554524f53204f55
				543a204e616461
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(11)
	666c6f617420765f6d7073
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(77)
	646f75626c6520616e675f76656c3b0a0a616e675f76656c203d206f2d3e4765
	745728293b0a0a6f2d3e4d6f76656d656e74436f6d6d616e6428765f6d70732c
	20616e675f76656c20293b0a0a
EndCompactStr
	Included object #1 (Srv) :
		Service: 
		[CambiarVW]
		Description:
			CompactStr(239)
				4e4f4d4252453a2043616d6269617256570a444553433a2043616d626961206c
				612076656c6f6369646164206c696e65616c207920616e67756c61722064656c
				20726f626f742e20456c2063616d62696f206e6f2073652070726f6475636972
				*ffe120696e7374616e74616e65616d656e74650a504152414d4554524f5320494e
				3a200a666c6f61742076203a2056656c6f6369646164206c696e65616c20656e
				206d6574726f73202f20736567756e646f0a666c6f617420773a204c61207665
				6c6f636964616420616e67756c617220656e207261642f7365670a504152414d
				4554524f53204f55543a204e616461
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(25)
	666c6f617420765f6d70730a666c6f617420775f7261647073
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(154)
	626f6f6c20726573756c743b0a234a4d532d494e434c55444528494e435f6372
	69746963616c7a6f6e65656e7465722c2230222c22726573756c742229230a0a
	6f2d3e4d6f76656d656e74436f6d6d616e6428765f6d70732c20775f72616470
	7320293b0a0a234a4d532d494e434c55444528494e435f637269746963616c7a
	6f6e656c656176652c2230222c22726573756c742229230a0a0a
EndCompactStr
	Included object #2 (Srv) :
		Service: 
		[CorregirPosicion]
		Description:
			CompactStr(246)
				4e4f4d4252453a20436f727265676972506f736963696f6e0a444553433a2043
				6f7272696765206c6f732076616c6f72657320646520706f736963696f6e2064
				656c20726f626f7420757361646f7320706f72206c61206f646f6d6574726961
				2e0a504152414d4554524f5320494e3a200a666c6f61742078203a20436f6f72
				64656e61646120656e206d6574726f730a666c6f61742079203a20436f6f7264
				656e61646120656e206d6574726f730a666c6f6174207068693a20416e67756c
				6f20646520646972656363696f6e616d69656e746f20656e2072616469616e65
				730a504152414d4554524f53204f55543a204e616461
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(25)
	666c6f617420780a666c6f617420790a666c6f617420706869
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(143)
	626f6f6c20726573756c743b0a234a4d532d494e434c55444528494e435f6372
	69746963616c7a6f6e65656e7465722c2230222c22726573756c742229230a0a
	6f2d3e52657365744f646f6d6574727928782c792c706869293b0a0a234a4d53
	2d494e434c55444528494e435f637269746963616c7a6f6e656c656176652c22
	30222c22726573756c742229230a0a
EndCompactStr
	Included object #3 (Srv) :
		Service: 
		[Girar]
		Description:
			CompactStr(294)
				4e4f4d4252453a2047697261720a5065726d69746520676972617220656c2072
				6f626f7420756e206e756d65726f20646520677261646f73206861636961206c
				6120697a717569657264612028706f73697469766f7329206f206c6120646572
				6563686120286e6567617469766f73292e20456c206769726f20736520646120
				656e20475241444f532e204c612076656c6f63696461642073652069676e6f72
				612c20706f6e65722061206365726f206f206375616c7175696572206f74726f
				2076616c6f722e0a4573746520736572766963696f206573206e6f2d626c6f71
				7565616e74652e20457869737465206f74726f20736572766963696f20717565
				2053492065737065726120686173746120717565207465726d696e6520656c20
				6769726f2e0a
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(27)
	666c6f617420677261646f730a666c6f61742076656c5f6769726f
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(355)
	666c6f617420782c792c7068693b0a6f2d3e4765744f646f6d65747279282678
	2c2026792c2026706869293b0a0a666c6f617420646972656363696f6e5f7261
	6473203d20706869202b204d5f50492a677261646f732f3138302e30663b0a0a
	7768696c652028646972656363696f6e5f72616473203e3d204d5f5049292020
	646972656363696f6e5f72616473202d3d2028666c6f61742928322a4d5f5049
	293b0a7768696c652028646972656363696f6e5f72616473203c3d2d4d5f5049
	292020646972656363696f6e5f72616473202b3d2028666c6f61742928322a4d
	5f5049293b0a0a2f2f204461746f73207061726120656c2068696c6f3a0a7469
	6d556c74696d6f53657448656164696e673d4765745469636b436f756e742829
	3b0a53657448656164696e675f5065746963696f6e203d20646972656363696f
	6e5f726164733b0a0a53657448656164696e67456e50726f6365736f3d747275
	653b0a
EndCompactStr
	Included object #4 (Srv) :
		Service: 
		[Girar_bloqueante]
		Description:
			CompactStr(152)
				457320696775616c2071756520224769726172222c20736f6c6f20717565206e
				6f207675656c76652068617374612071756520736520686120636f6d706c6574
				61646f20656c206769726f0a285369206f637572726965736520756e20657272
				6f722c20766f6c766572696120656e20756e6f7320313020736567756e646f73
				2c20616c2073616c74617220756e2074696d656f7574290a
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(27)
	666c6f617420677261646f730a666c6f61742076656c5f6769726f
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(521)
	666c6f617420782c792c7068693b0a6f2d3e4765744f646f6d65747279282678
	2c2026792c2026706869293b0a0a666c6f617420646972656363696f6e5f7261
	6473203d20706869202b204d5f50492a677261646f732f3138302e30663b0a0a
	7768696c652028646972656363696f6e5f72616473203e3d204d5f5049292020
	646972656363696f6e5f72616473202d3d2028666c6f61742928322a4d5f5049
	293b0a7768696c652028646972656363696f6e5f72616473203c3d2d4d5f5049
	292020646972656363696f6e5f72616473202b3d2028666c6f61742928322a4d
	5f5049293b0a0a2f2f204461746f73207061726120656c2068696c6f3a0a7469
	6d556c74696d6f53657448656164696e673d4765745469636b436f756e742829
	3b0a53657448656164696e675f5065746963696f6e203d20646972656363696f
	6e5f726164733b0a0a53657448656164696e67456e50726f6365736f3d747275
	653b0a0a7072696e746628225b47697261725f626c6f717565616e74655d2045
	73706572616e646f2061207175652066696e616c69636520656c206769726f2e
	2e2e5c6e22293b0a0a7768696c65202853657448656164696e67456e50726f63
	65736f2920090a09536c65657028313030293b0a0a7072696e746628225b4769
	7261725f626c6f717565616e74655d204769726f2066696e616c697a61646f21
	215c6e22293b0a0a0a
EndCompactStr
	Included object #5 (Srv) :
		Service: 
		[LeerPose]
		Description:
			CompactStr(189)
				4e4f4d4252453a204c656572506f73650a444553433a204f627469656e65206c
				6120706f736963696f6e2061637475616c2064656c20726f626f742e0a504152
				414d4554524f5320494e3a204e6164610a504152414d4554524f53204f55543a
				0a666c6f61742078203a20436f6f7264656e61646120656e206d6574726f730a
				666c6f61742079203a20436f6f7264656e61646120656e206d6574726f730a66
				6c6f6174207068693a20416e67756c6f20656e2072616469616e65730a
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(25)
	666c6f617420780a666c6f617420790a666c6f617420706869
EndCompactStr
		Server code:[INF,INF]
CompactStr(236)
	626f6f6c20726573756c743b0a234a4d532d494e434c55444528494e435f6372
	69746963616c7a6f6e65656e7465722c2230222c22726573756c742229230a0a
	0a666c6f6174206f646f6d5f782c206f646f6d5f792c206f646f6d5f7068693b
	0a0a6f2d3e4765744f646f6d6574727928266f646f6d5f782c20266f646f6d5f
	792c20266f646f6d5f706869293b0a0a78203d206f646f6d5f783b0a79203d20
	6f646f6d5f793b0a706869203d206f646f6d5f7068693b0a0a234a4d532d494e
	434c55444528494e435f637269746963616c7a6f6e656c656176652c2230222c
	22726573756c742229230a0a
EndCompactStr
	Included object #6 (Srv) :
		Service: 
		[LeerPoseREAL]
		Description:
			CompactStr(159)
				44657675656c7665206c6120706f736963696f6e207265616c2064656c20726f
				626f742c206e6f206c61206f646f6d6574726963612e200a45766964656e7465
				6d656e7465206573746520736572766963696f2073652068612061*fff161646964
				6f20616c2073696d756c61646f722079206e6f206573746120656e200a6c6f73
				206d6f64756c6f73206465206c6f7320726f626f7473207265616c65732e0a
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(25)
	666c6f617420780a666c6f617420790a666c6f617420706869
EndCompactStr
		Server code:[INF,INF]
CompactStr(109)
	78203d206f2d3e4765745828293b0a79203d206f2d3e4765745928293b0a7068
	69203d206f2d3e47657450484928293b0a0a7072696e746628225b4c65657220
	706f7365207265616c5d2025662025662025665c6e222c782c792c7068692a31
	38302f332e3134313566293b0a
EndCompactStr
	Included object #7 (Srv) :
		Service: 
		[LeerPoseVW]
		Description:
			CompactStr(342)
				4e4f4d4252453a204c656572506f736556570a444553433a205065726d697465
				206c656572206c6120706f736963696f6e2c2076656c6f63696461646573206c
				696e65616c6573207920616e67756c6172657320656e20756e206d6f6d656e74
				6f2064657465726d696e61646f2e0a504152414d4554524f5320494e3a204e4f
				0a504152414d4554524f53204f55543a0a2d3e666c6f617420783a20506f7369
				63696f6e20286d6574726f73290a2d3e666c6f617420793a20506f736963696f
				6e20286d6574726f73290a2d3e666c6f6174207068693a20416e67756c6f2028
				72616469616e6573290a2d3e666c6f61742076656c4c696e65616c3a2056656c
				6f636964616420656e206d6574726f7320706f7220736567756e646f2e0a2d3e
				666c6f61742076656c416e67756c61723a2056656c6f636964616420656e2072
				616469616e657320706f7220736567756e646f2e0a0a
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(58)
	666c6f617420780a666c6f617420790a666c6f6174207068690a666c6f617420
	76656c4c696e65616c0a666c6f61742076656c416e67756c6172
EndCompactStr
		Server code:[INF,INF]
CompactStr(327)
	626f6f6c20726573756c743b0a234a4d532d494e434c55444528494e435f6372
	69746963616c7a6f6e65656e7465722c2230222c22726573756c742229230a0a
	666c6f6174206f646f6d5f782c206f646f6d5f792c206f646f6d5f7068693b0a
	0a6f2d3e4765744f646f6d6574727928266f646f6d5f782c20266f646f6d5f79
	2c20266f646f6d5f706869293b0a0a78203d206f646f6d5f783b0a79203d206f
	646f6d5f793b0a706869203d206f646f6d5f7068693b0a0a76656c4c696e6561
	6c203d206f2d3e4765745628293b20202f2f206d6574726f732f6d696e0a7665
	6c416e67756c6172203d206f2d3e4765745728293b202f2f2053652064616e20
	656e20444543454e415320646520*ffba2f7365670a0a234a4d532d494e434c5544
	4528494e435f637269746963616c7a6f6e656c656176652c2230222c22726573
	756c742229230a
EndCompactStr
	Included object #8 (Srv) :
		Service: 
		[MONITOR]
		Description:
			CompactStr(79)
				45737465206d6f6e69746f7220736520656e636172676120646520656a656375
				746172206c612073696d756c6163696f6e206465206c612073696c6c61206465
				20666f726d6120636f6e74696e7561
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <MP>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(467)
	626f6f6c20726573756c743b0a73746174696320696e74206361646158203d20
	303b0a0a234a4d532d494e434c55444528494e435f637269746963616c7a6f6e
	65656e7465722c2230222c22726573756c742229230a6f2d3e53696d756c6174
	65496e74657276616c28302e3035293b0a234a4d532d494e434c55444528494e
	435f637269746963616c7a6f6e656c656176652c2230222c22726573756c7422
	29230a0a536c656570283530293b0a0a0a6966202863616461582b2b3e343029
	0a7b0a0963616461583d303b0a0a09666c6f6174206f646f6d5f782c206f646f
	6d5f792c206f646f6d5f7068693b0a096f2d3e4765744f646f6d657472792826
	6f646f6d5f782c20266f646f6d5f792c20266f646f6d5f706869293b0a0a0970
	72696e7466282243757272656e7420706f73653a28252e3033662c252e303366
	2c252e303266646567292c206f646f3d28252e3033662c252e3033662c252e30
	3266646567295c6e222c0a09096f2d3e4765745828292c0a09096f2d3e476574
	5928292c0a09096f2d3e47657450484928292a3138302f332e3134313539662c
	0a09096f646f6d5f782c0a09096f646f6d5f792c0a09096f646f6d5f7068692a
	3138302f332e31343135396620293b0a7d0a0a
EndCompactStr
	Included object #9 (Srv) :
		Service: 
		[MONITOR_SET_HEADING]
		Description:
			CompactStr(313)
				42617361646120656e2065737465206d65746f646f2064656c20496e74657266
				617a434f5242412064656c2050696f6e6565723a0a45737465206d6f6e69746f
				7220736520656e6361726761206465206d6f6e69746f72697a6172207369206c
				6f73206769726f732070656469646f73207365207465726d696e616e20646520
				63756d706c69722c200a726570697469656e646f206c61206f7264656e206475
				72616e746520756e207469656d706f2c20686173746120717565207365206c6c
				6567612e204573206e656365736172696120706f7271756520616c200a636f72
				7265676972206c6120706f736963696f6e20656c2050494f4e455220706f7220
				6c6f20766973746f206e6f207469656e6520656e206375656e7461206c6f7320
				696e6372656d656e746f7320646520616e67756c6f732e0a0a
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <MP>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(947)
	0a09666c6f617420575f4d4158203d2035302a4d5f50492f3138302e30663b09
	2f2f20*ffba2f7365670a09666c6f6174204449465f4d494e203d20352a4d5f5049
	2f3138302e30663b092f2f20*ffba0a09090a096966202853657448656164696e67
	456e50726f6365736f290a097b0a0909666c6f617420782c792c7068692c6469
	663b0a09090a09096f2d3e4765744f646f6d657472792826782c2026792c2026
	706869293b0a090a0909646966203d2053657448656164696e675f5065746963
	696f6e202d207068693b0a09090a09097768696c6520286469663e3d4d5f5049
	292020646966202d3d2028666c6f61742928322a4d5f5049293b0a0909776869
	6c6520286469663c3d2d4d5f5049292020646966202b3d2028666c6f61742928
	322a4d5f5049293b0a090a09092f2f205365206861207465726d696e61646f3f
	3f0a090969662028206661627328646966293c4449465f4d494e2029200a0909
	7b0a0909096f2d3e4d6f76656d656e74436f6d6d616e6428302c30293b0a0909
	0953657448656164696e67456e50726f6365736f203d2066616c73653b0a0909
	7d0a0909656c73650a09097b0a0909092f2f2054696d656f75743f3f0a090909
	69662028284765745469636b436f756e7428292d74696d556c74696d6f536574
	48656164696e67293e3830303029200a0909097b0a090909096f2d3e4d6f7665
	6d656e74436f6d6d616e6428302c3020293b0a0909090953657448656164696e
	67456e50726f6365736f203d2066616c73653b0a0909097d0a090909656c7365
	0a0909097b0a090909092f2f20446172206f7264656e3a0a090909092f2f096f
	2d3e53657448656164696e672853657448656164696e675f5065746963696f6e
	293b0a09090909666c6f61742057203d20286661627328646966292b302e3532
	29202f20312e35373b0a09090909696620286469663c3029573d2d573b0a0a09
	09090969662028573e312920573d313b0a0909090969662028573c2d31292057
	3d2d313b0a090909096f2d3e4d6f76656d656e74436f6d6d616e6428302c572a
	575f4d4158293b0a090909097072696e746628225b4d4f4e49544f525f534554
	5f48454144494e475d20476972616e646f20686173746120252e303266206772
	61642e2e2e205048492061637475616c203d20252e303266677261645c6e222c
	53657448656164696e675f5065746963696f6e2a3138302e30662f4d5f50492c
	7068692a3138302e30662f4d5f5049293b0a0909097d0909090909090a09097d
	0a097d0a090a536c65657028313530293b0a0a
EndCompactStr
	Included object #10 (Srv) :
		Service: 
		[PararSilla]
		Description:
			CompactStr(110)
				4e4f4d4252453a20506172617253696c6c610a444553433a205265616c697a61
				20756e612070617261646120646520656d657267656e6369612064656c20726f
				626f742e0a504152414d4554524f5320494e3a204e6164610a504152414d4554
				524f53204f55543a204e6164610a
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(28)
	6f2d3e4d6f76656d656e74436f6d6d616e64282030202c2030293b0a
EndCompactStr
	Included object #11 (Srv) :
		Service: 
		[SetHeading]
		Description:
			CompactStr(134)
				5065726d69746520646563697220616c20726f626f7420756e61206469726563
				63696f6e2061206c6120717565207469656e65207175652067697261722e204c
				6c616d616461206e6f20626c6f717565616e74652e0a456c20616e67756c6f20
				64652068656164696e67206465736561646f20736520646120656e2072616469
				616e65732e0a
			EndCompactStr
		Linked to the object: [<Default group>]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <R>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(20)
	666c6f617420646972656363696f6e5f72616473
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(126)
	2f2f204461746f73207061726120656c2068696c6f3a0a74696d556c74696d6f
	53657448656164696e673d4765745469636b436f756e7428293b0a5365744865
	6164696e675f5065746963696f6e203d20646972656363696f6e5f726164733b
	0a0a53657448656164696e67456e50726f6365736f3d747275653b0a0a0a
EndCompactStr
Included object #1 (SGr) :
	Group of Services: 
	[Watchdog]
	Description:
		CompactStr(108)
			4d6f64756c6f732072656c6163696f6e61646f7320636f6e20656c2057617463
			68646f672e200a28456e20657374652073696d756c61646f72206e6f20657374
			6120696d706c656d656e7461646f2c207920737573206c6c616d616461732073
			652069676e6f72616e212129
		EndCompactStr
	Linked to the object: [InterfazCORBA]
	Includes (2) objects.
	Included object #0 (Srv) :
		Service: 
		[InitWatchdog]
		Description:
			CompactStr(38)
				2849676e6f7261646f2c20656e20656c2073696d756c61646f72206e6f206861
				792057445429
			EndCompactStr
		Linked to the object: [Watchdog]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <R>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(10)
	666c6f617420545f6d73
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(0)
EndCompactStr
	Included object #1 (Srv) :
		Service: 
		[StopWatchdog]
		Description:
			CompactStr(38)
				2849676e6f7261646f2c20656e20656c2073696d756c61646f72206e6f206861
				792057445429
			EndCompactStr
		Linked to the object: [Watchdog]
		Type: 0
		Event Handler Code: (0)
		Event Generator Module: ()
		Characteristics: <R>
		Relative priority: (0)
		Input data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Output data definition:[INF,INF]
CompactStr(0)
EndCompactStr
		Server code:[INF,INF]
CompactStr(0)
EndCompactStr
Relative priority: (0)
External data: (1) [F:\Datos\fuentesbabel\babel\DirectorioDeEjecucion\ices\interfazcorba]/[CSenaSimulator.h]@1233830084 
External code: (1) [d:\Trabajo\Code\Modulos BABEL\INDEPENDIENTES_ROBOT\ICE_InterfazCORBA (Simulador)\Clases C++]/[CSenaSimulator.cpp]@1129051226 
External passive: (1) [d:\Trabajo\Code\Modulos BABEL\KIT_BABEL_test_new]/[CONFIG_InterfazCORBA_SIMULATOR.ini]@1183049060 
Global data:[INF,INF]
CompactStr(132)
	0a2f2f20456c206f626a65746f2064656c2073696d756c61646f720a4353656e
	6153696d756c61746f72202a6f3b0a0a0a626f6f6c0953657448656164696e67
	456e50726f6365736f3b0a44574f5244202074696d556c74696d6f5365744865
	6164696e673b0a666c6f6174202053657448656164696e675f5065746963696f
	6e3b0a0a
EndCompactStr
Global code:[INF,INF]
CompactStr(0)
EndCompactStr
Pre-definitions:[INF,INF]
CompactStr(0)
EndCompactStr
Startup code:[INF,INF]
CompactStr(696)
	0a23646566696e6520494e495f46494c455f4e414d4509222e5c5c434f4e4649
	475f496e74657266617a434f5242415f53494d554c41544f522e696e69220a0a
	2f2f20437265617220656c206f626a65746f3a0a6f203d206e6577204353656e
	6153696d756c61746f7228293b0a0a2f2f20496e69636961722073696d756c61
	646f723a0a6f2d3e526573657453746174757328293b0a0a2f2f204e4f204552
	524f524553204f444f4d45545249434f533a0a6f2d3e5365744f646f6d657472
	794572726f72732866616c7365293b0a0a2f2f20494e495449414c20504f5345
	3a0a2f2f202d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d0a636861
	72207374725b313030305d3b0a4765745072697661746550726f66696c655374
	72696e6728225374617274696e67506f7365222c2278222c2230222c7374722c
	203130302c494e495f46494c455f4e414d45293b0a6f2d3e5365745828206174
	6f66287374722920293b0a4765745072697661746550726f66696c6553747269
	6e6728225374617274696e67506f7365222c2279222c2230222c7374722c2031
	30302c494e495f46494c455f4e414d45293b0a6f2d3e53657459282061746f66
	287374722920293b0a4765745072697661746550726f66696c65537472696e67
	28225374617274696e67506f7365222c22706869222c2230222c7374722c2031
	30302c494e495f46494c455f4e414d45293b0a6f2d3e53657450484928206174
	6f662873747229202a20302e3031373435333239323531393934333239353736
	393233363930373638343838366620293b0a0a53657448656164696e67456e50
	726f6365736f3d303b0a0a2f2f2053656d61666f726f733a0a626f6f6c207265
	73756c743b0a234a4d532d494e434c55444528494e435f637269746963616c7a
	6f6e656372656174652c2231222c22726573756c74222923
EndCompactStr
Pre-ending code:[INF,INF]
CompactStr(10)
	0a64656c657465206f3b
EndCompactStr
Post-ending code:[INF,INF]
CompactStr(0)
EndCompactStr
Codification language:
	(P)
Deportabilization:
	[{(H):0|}{(E):0|}{(R):0|}{(F):0|}{(C):0|}]
Dependencies:
	{(0) }
Defined signals:
	[]
General information:
	CompactStr(3)
		312e30
	EndCompactStr
	CompactStr(10)
		30352f30322f32303039
	EndCompactStr
	CompactStr(4)
		4a4c4243
	EndCompactStr
	CompactStr(7)
		4e696e67756e61
	EndCompactStr
	CompactStr(0)
	EndCompactStr
$   CSenaSimulator.cpp                                                                                                              j  #  CONFIG_InterfazCORBA_SIMULATOR.ini                                                                                              "  @  CSenaSimulator.h RBA_SIMULATOR.ini                                                                                              b  e  /*************************************************************************
	CLASE: CSenaSimulator

	DESCRIPCION:
                Implementa una clase que permite simular el robot Sena,
                 en cuanto a su posicionamiento, movimiento y sensores
                 de movimiento.
                Usa cambios de velocidad LINEALES, lo que simula los
                 retardos reales al cambiar de velocidad.

	REVISIONES:
		18/JUN/2004: Comienzo. Jose Luis Blanco Claraco
                1/DIC/2004: (JLBC) Aado errores de odometria acumulativos:
                   Cuanto mas se anda, mayor es el error odometrico, como
                   en los robots reales.

*************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "CSenaSimulator.h"



/*************************************************************************
        Constructor
*************************************************************************/
CSenaSimulator::CSenaSimulator()
{
        nPuntosModeloRobot=0;

        DistanciaLaser=1.0;             // 1m entre LASER y pto. de ref.

        usar_error_odometrico = false;

        ResetStatus();
}

/*************************************************************************
        Destructor
*************************************************************************/
CSenaSimulator::~CSenaSimulator()
{


}


/*************************************************************************
        Cargar modelo de poligonos del robot.
  Devuelve false si error
*************************************************************************/
bool    CSenaSimulator::LoadRobotModel( char *filename )
{
        FILE    *f;
        char    str[100];
        double  x,y;

        f=fopen( filename, "rt" );
        if (!f) return false;

        nPuntosModeloRobot=0;

        while (!feof(f))
        {
             // Coger linea con dos puntos:
             if (fgets(str,99,f))
             {
                // Quitar caracteres finales:
                while ( !isdigit(str[strlen(str)-1]) && strlen(str) )
                        str[strlen(str)-1]=0;

                // Sacar los dos doubles:
                x=1e300;
                y=1e300;
                sscanf(str, "%lf %lf", &x, &y);

                if (y!=1e300 && x!=1e300)
                {
                        modeloRobot[nPuntosModeloRobot].x=x;
                        modeloRobot[nPuntosModeloRobot].y=y;
                        nPuntosModeloRobot++;
                }
             }
        }

        fclose(f);

        return true;
}

/*************************************************************************
                        Incremento de tiempo

 Simula el robot durante este tiempo: Velocidades, giros, movimientos,...
*************************************************************************/
void    CSenaSimulator::SimulateInterval( double At)
{
        double  dx,dy,dx_odo,dy_odo;          // Incremento de X e Y en este intervalo:
        double  curvatura;
        double  w_radianes;
        double  mod,ang;
        double  AAt, tt;

        tt = 0.0;
        AAt = 0.005;     // Paso minimo de tiempo a simular:

      while (tt<At)
      {
        t+= AAt;
        tt+=AAt;

        // Cambiar velocidades:
        // ----------------------------------------------------------------
        double t_transcurrido = t - Command_Time;
        v = Command_v0 + (Command_v-Command_v0)*(1-exp(-t_transcurrido/TAU_V));
        w = Command_w0 + (Command_w-Command_w0)*(1-exp(-t_transcurrido/TAU_W));


        // Simular movimiento en lneas o circulos durante el periodo At:
        // ----------------------------------------------------------------
        if ( v != 0.0 )
        {
                w_radianes = w;

                curvatura = w_radianes / v;

                if ( curvatura != 0.0 )
                {
                        // Curva circular:
                        double dx0 = dx = (sin(  w_radianes * AAt ) / curvatura);
                        double dy0 = dy = (1-cos( w_radianes * AAt ) ) / curvatura;

						mod = sqrt(dx*dx+dy*dy);
						ang = atan2(dy0, dx0);
						ang += PHI;
                        dx = mod * cos(ang);
                        dy = mod * sin(ang);

						ang = atan2(dy0, dx0);
                        ang+= odo_phi;
                        dx_odo = mod * cos(ang);
                        dy_odo = mod * sin(ang);
                }
                else
                {
                        // Linea recta:
                        dx =  cos( PHI ) * v * AAt;
                        dy =  sin( PHI ) * v * AAt;

                        dx_odo = cos( odo_phi ) * v * AAt;
                        dy_odo = sin( odo_phi ) * v * AAt;
                }

                // Las posiciones reales:
                X+= dx;
                Y+= dy;

                // y las odometricas (con ruido)
                odo_x+=dx_odo; if (usar_error_odometrico) odo_x+=-0.0005+0.00055*(random(1000)/1000.0);
                odo_y+=dy_odo; if (usar_error_odometrico) odo_y+=-0.0005+0.00055*(random(1000)/1000.0);;

        }

        PHI+= w*AAt;
        while (PHI> M_PI)  PHI-=(float)(2*M_PI); 
		while (PHI<-M_PI)  PHI+=(float)(2*M_PI);

        odo_phi+=w*AAt; 
		if (usar_error_odometrico)  odo_phi+=-0.0006f+0.0008f*(random(1000)/1000.0);
        while (odo_phi> M_PI)  odo_phi-=(float)(2*M_PI); 
		while (odo_phi<-M_PI)  odo_phi+=(float)(2*M_PI);
      }

}

/*************************************************************************
  Devuelve uno de los puntos del modelo, girado PHI y desplazado a (X,Y)
*************************************************************************/
void    CSenaSimulator::GetTranslatedAndRotatedPoint( int Index, TPunto* point)
{
        double  px,py;
        double  mod,teta;

        // Coger puntos referenciados al pto de ref. de la silla:
        px= modeloRobot[Index].x;
        py= modeloRobot[Index].y;

        // Modulo y fase:
        mod  = sqrt( px*px+py*py );
        teta = atan2( py, px  );

        // Girar:
        teta+= PHI;

        // Pasar a coordenadas de nuevo:
        px= cos(teta)*mod;
        py= sin(teta)*mod;

        // Trasladar a (X,Y):
        point->x=X+px;
        point->y=Y+py;
}

/*************************************************************************
  Devuelve el punto del LASER, girado PHI y desplazado a (X,Y)
*************************************************************************/
void    CSenaSimulator::GetLASERPoint( TPunto *punto )
{
        double  px,py;
        double  mod,teta;

        // Coger puntos referenciados al pto de ref. de la silla:
        py= 0;
        px= DistanciaLaser;

        // Modulo y fase:
        mod  = sqrt( px*px+py*py );
        teta = atan2( py, px  );

        // Girar:
        teta+= PHI;

        // Pasar a coordenadas de nuevo:
        px=  cos(teta)*mod;
        py=  sin(teta)*mod;

        // Trasladar a (X,Y):
        punto->x=X+px;
        punto->y=Y+py;

}

/*************************************************************************
  Devuelve un punto referenciado al centro de la silla (x0,y0), en
   coordenadas del mundo (x,y). Gira y suma las coordenadas.
*************************************************************************/
void    CSenaSimulator::TranslatePoint( float x0, float y0, float* x, float* y )
{
        double  px,py;
        double  mod,teta;

        // Coger puntos referenciados al pto de ref. de la silla:
        px= x0;
        py= y0;

        if (px!=0.0 && py!=0.0)
        {
                // Modulo y fase:
                mod  = sqrt( px*px+py*py );
                teta = atan2( py, py );

                // Girar:
                teta+= PHI;

                // Pasar a coordenadas de nuevo:
                px=  cos(teta)*mod;
                py=  sin(teta)*mod;
        }

        // Trasladar a (X,Y):
        *x=(float)(X+px);
        *y=(float)(Y+py);

}


/*************************************************************************
        Dar un comando de movimiento al robot:

   Guarda los valores para ir ejecutando el movimiento poco a poco,
    teniendo en cuenta los tiempos de reaccion.
*************************************************************************/
void    CSenaSimulator::MovementCommand ( double lin_vel, double ang_vel )
{
        // Apuntar datos para ejecutarlos lentamente, segun
        //   la respuesta del robot:
        Command_Time = t;
        Command_v = lin_vel;
        Command_w = ang_vel;

        // Actuales:
        Command_v0 = v;
        Command_w0 = w;

}



; ---------------------------------------------------------------
; FILE: CONFIG_InterfazCORBA_SIMULATOR.ini
;
;  Parameters for the robot simulator module.
;
;  JLBC @ 2006-2007
; ---------------------------------------------------------------

[StartingPose]
x=0		; meters
y=0		; meters
phi=0		; degrees

/*************************************************************************
	CLASE: CSenaSimulator

	DESCRIPCION DEL FICHERO:
		Aqui se declara la clase, que se implementa en el ".cpp"
	REVISIONES:
		Ver fichero CPP
*************************************************************************/

#ifndef CSenaSimulatorH
#define CSenaSimulatorH

#include <math.h>

#define TAU_V                   0.05 //1.9
#define TAU_W                   0.05 //1.8

#ifndef M_PI
	#define	M_PI					3.1415926535897932384626433832795f
#endif
#ifndef random
	#define random(X)				(rand()%X)
#endif

struct TPunto {
        double x,y;
};

class CSenaSimulator
{
private:
	//	Estado interno del objeto:
	// ---------------------------------------
        // Coordenadas y orientacion en un sistema de referencia externo al robot
        double          X,Y,PHI;        // PHI: Angulo en grados desde el eje OX, sentido antihorario = positivo

        // Velocidad lineal (metros / seg):
        double          v;

        // Velocidad de giro ( grados / seg): Positivo = Hacia la izquierda.
        double          w;

        // Referencia de tiempo actual:
        double          t;

        // Para odometria:
        double          odo_x,odo_y,odo_phi;
        bool            usar_error_odometrico;          // Si meter o no error en la odometria:

        // Lista de poligonos que definen el robot:
        TPunto          modeloRobot[100];
        int             nPuntosModeloRobot;

        // Distancia desde el punto de referencia del robot al punto
        //   de referencia del LASER. Normalmente casi un metro.
        double          DistanciaLaser;

        // Limitaciones dinamicas del robot: Aproximacion a las fuerzas limitadas
        //  de los motores: Se usa aproximacion paso bajo de primer orden
        double          Command_Time;    // el momento "t" en que se dio la orden
        double          Command_v, Command_w;   // Los comandos
        double          Command_v0, Command_w0; // Valores (v,w) en el momento del comando

        // Minimo radio de giro = Semieje de las ruedas
        double          KinematicLimit_MinRadius;

       

public:
	//	Metodos publicos
	// ---------------------------------------

	// Constructor
	CSenaSimulator();

	// Destructor
	~CSenaSimulator();

        // Activar/desactivar errores en odometria:
        void SetOdometryErrors( bool enabled ) { usar_error_odometrico=enabled; }

        // Cambiar posicion de golpe:
        void    SetX(double X) { this->X=odo_x=X; }
        void    SetY(double Y) { this->Y=odo_y=Y; }
        void    SetPHI(double PHI) { this->PHI=odo_phi=PHI; }

        // Leer estado instantaneo:
        double  GetX() { return X; }
        double  GetY() { return Y; }
        double  GetPHI() { return PHI; }
        double  GetT()   { return t; }

        // Velocidades lin. y ang.
        double  GetV() { return v; }
        double  GetW() { return w; }

        // Radio de giro y curvatura: Solo lectura:
        double  GetR()    { if (w!=0) return (v*180)/(w*M_PI); else return 0.0;  }
        double  GetCurv() { if (v!=0) return (w*M_PI)/(v*180); else return 0.0;  }

        // Cambiar velocidades de golpe. No usar normalmente!:
        void    SetV(double v) { this->v=v; }
        void    SetW(double w) { this->w=w; }

        // Dar un comando de movimiento al robot:
        void    MovementCommand ( double lin_vel, double ang_vel );

        // Distancia al LASER:
        void    SetDistanciaLaser(double dl) { DistanciaLaser=dl; }
        double  GetDistanciaLaser() { return DistanciaLaser; }
        void    GetLASERPoint( TPunto *punto);

        void    TranslatePoint( float x0, float y0, float* x, float* y );

        // Inicia todos los valores, menos en modelo del robot.
        void    ResetStatus()
        {
                X=Y=PHI=t=0.0;
                odo_x=odo_y=odo_phi=0.0;
                v=w=0.0;
                KinematicLimit_MinRadius=0.8;   // Radio minimo de giro = 1/2 de eje de ruedas
                Command_Time = 0.0;
                Command_v = Command_w = Command_v0 = Command_w0 = 0.0;
        }

        // Pone el tiempo a cero de nuevo:
        void    ResetTime()  { t = 0.0; }

        // Incremento de tiempo: Simula el robot durante este tiempo.
        void    SimulateInterval( double At);

        // Cargar modelo de poligonos del robot. Devuelve false si error
        bool    LoadRobotModel( char *filename );


        // Minimo radio de giro = Semieje de las ruedas
        double  GetKinematicLimit_MinRadius() { return KinematicLimit_MinRadius; }
        void    SetKinematicLimit_MinRadius(double MinRadius) { KinematicLimit_MinRadius = MinRadius; }


        // Funciones para el tratamiento de los poligonos del robot:
        int     GetCuantosPuntos() { return nPuntosModeloRobot; }
        void    GetTranslatedAndRotatedPoint( int Index, TPunto* point);

        // Odometria:
        void    ResetOdometry( double x, double y, double phi )
        {
                odo_x   = x;
                odo_y   = y;
                odo_phi = phi;
        }
        void    GetOdometry (float *x, float *y, float *phi)
        {
                *x= (float)odo_x;
                *y= (float)odo_y;
                *phi= (float)odo_phi;
        }


};


#endif
