/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef UTILS_H
#define UTILS_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/MRPT_OS.h>

#include <iostream>

/** Various math and utilities classes and definitions.
 */
namespace UTILS
{
	/** You must call UTILS::registerAllClasses() before parsing objects from binary streams of classes
	  *   that are not explicitly used in your application. If it is called more than once, it has no effect.
	  */
	void registerAllClasses();
}

// Math classes:
#include <MRPT/UTILS/CMatrixTemplateNumeric.h>
#include <MRPT/UTILS/CMatrixTemplateObjects.h>
#include <MRPT/UTILS/CMatrix.h>
#include <MRPT/UTILS/CMatrixD.h>

#include <MRPT/UTILS/CVectorTemplate.h>
#include <MRPT/UTILS/CKalmanFilterCapable.h>
#include <MRPT/UTILS/CQuaternion.h>

#include <MRPT/UTILS/CDebugOutputCapable.h>
#include <MRPT/UTILS/RandomGenerator.h>
#include <MRPT/UTILS/CHistogram.h>
#include <MRPT/UTILS/CGraphPartitioner.h>
#include <MRPT/UTILS/CParticleFilter.h>
#include <MRPT/UTILS/CParticleFilterData.h>
#include <MRPT/UTILS/CParticleFilterCapable.h>
#include <MRPT/UTILS/CRejectionSamplingCapable.h>
#include <MRPT/UTILS/CPolygon.h>
#include <MRPT/UTILS/CProbabilityParticle.h>
#include <MRPT/UTILS/CStringList.h>


// CStream related classes:
#include <MRPT/UTILS/CSerializable.h>
#include <MRPT/UTILS/CStream.h>
#include <MRPT/UTILS/CMemoryStream.h>
#include <MRPT/UTILS/CFileStream.h>
#include <MRPT/UTILS/CFileInputStream.h>
#include <MRPT/UTILS/CFileOutputStream.h>
#include <MRPT/UTILS/CMemoryChunk.h>

// TCP sockets:
#include <MRPT/UTILS/CServerTCPSocket.h>
#include <MRPT/UTILS/CClientTCPSocket.h>

// Others:
#include <MRPT/UTILS/SystemUtils.h>
#include <MRPT/UTILS/CDisplayWindow.h>
#include <MRPT/UTILS/CDisplayWindow3D.h>
#include <MRPT/UTILS/CDisplayWindowPlots.h>

#include <MRPT/UTILS/GEO.h>
#include <MRPT/UTILS/MRPT_math.h>
#include <MRPT/UTILS/SYNCH.h>

#include <MRPT/UTILS/ZipCompression.h>

#include <MRPT/UTILS/CEnhancedMetaFile.h>
#include <MRPT/UTILS/CMRPTCanvas.h>
#include <MRPT/UTILS/CMRPTImage.h>
#include <MRPT/UTILS/CMRPTImageFloat.h>
#include <MRPT/UTILS/CDirectoryExplorer.h>
#include <MRPT/UTILS/CTicTac.h>
#include <MRPT/UTILS/CJoystick.h>
#include <MRPT/UTILS/CSimpleDatabase.h>
#include <MRPT/UTILS/CPropertiesValuesList.h>
#include <MRPT/UTILS/CMHPropertiesValuesList.h>
#include <MRPT/UTILS/CTypeSelector.h>
#include <MRPT/UTILS/CHillClimbing.h>
#include <MRPT/UTILS/CLoadableOptions.h>
#include <MRPT/UTILS/CDynamicGrid.h>
#include <MRPT/UTILS/CMRPTMessage.h>
#include <MRPT/UTILS/COpenGLScene.h>

#include <MRPT/UTILS/CConfigFile.h>
#include <MRPT/UTILS/CConfigFileMemory.h>

#include <MRPT/UTILS/CMessageQueue.h>

#endif

