/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef  CFileInputStream_H
#define  CFileInputStream_H

#include <MRPT/UTILS/CStream.h>

#include <iostream>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This CStream derived class allow using a file as a read-only, binary stream.
	 *
	 * \sa CStream, CFileStream
	 */
	class CFileInputStream : public CStream
	{
	protected:
		 /** Method responsible for reading from the stream.
		 */
		size_t  Read(void *Buffer, size_t Count);

		/** Method responsible for writing to the stream.
		 *  Write attempts to write up to Count bytes to Buffer, and returns the number of bytes actually written.
		 */
		size_t  Write(const void *Buffer, size_t Count);

	private:
		std::ifstream 	m_if;		//!< The actual input file stream.

	public:
		 /** Constructor
		  * \param fileName The file to be open in this stream
		  */
		CFileInputStream(const std::string &fileName );

		CFileInputStream(const CFileInputStream&o); //!< Copy not allowed (raises exception)
		CFileInputStream & operator =( const CFileInputStream& o); //!< Copy not allowed (raises exception)

		 /** Destructor
		 */
		 virtual ~CFileInputStream();

		 /** Says if file was open successfully or not.
		  */
		 bool  fileOpenCorrectly();

		 /** Will be true if EOF has been already reached.
		   */
		 bool checkEOF();

		/** Method for moving to a specified position in the streamed resource.
		 *   See documentation of CStream::Seek
		 */
		size_t Seek(long Offset, CStream::TSeekOrigin Origin = sFromBeginning);

		/** Method for getting the total number of bytes writen to buffer.
		 */
		size_t getTotalBytesCount();

		/** Method for getting the current cursor position, where 0 is the first byte and TotalBytesCount-1 the last one.
		 */
		size_t getPosition();

		/** Reads one string line from the file (until a new-line character)
		  * \return true if a line has been read, false on EOF or error.
		  */
        bool readLine( std::string &str );

	}; // End of class def.

} // End of namespace

#endif
