/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CHarrisFeatureDetector_H
#define CHarrisFeatureDetector_H

#include <MRPT/UTILS/CMRPTImage.h>
#include <MRPT/UTILS/CMRPTImageFloat.h>
#include <MRPT/MRVL/CGaussianConvolutionKernel.h>
#include <MRPT/MRML/CPointsMap.h>

namespace MRVL
{
	/** This class integrates a Harris feature detector for gray-scale images.
	  * \sa MRVL
	  */
	class CHarrisFeatureDetector
	{
	public:
		/** Options for the KLT algorithm:
		*/
		struct TOptions
		{
			/** Initializer for default values
			*/
			TOptions();

		} m_options;

		/** Computes the Harris features for the image "img" and according to parameters in "m_options", returning the "x" and "y" coordinates of each feature in a "MRML::CPointsMap" class.
		  */
		void  extractFeatures(
			const CMRPTImageFloat	&in_img,
			MRML::CPointsMap				&out_points
			);

	};	// End of class "CHarrisFeatureDetector"

} // End of namespace


#endif
