/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CGaussianConvolutionKernel_H
#define CGaussianConvolutionKernel_H

#include <MRPT/UTILS/CMRPTImage.h>
#include <MRPT/UTILS/CMRPTImageFloat.h>

namespace MRVL
{
	/** This class represents a generic "convolution kernel", that can actually represent any Gaussian or DOG filter.
	  *  The class that performs the actual convolution is MRVL::CImageConvolution
	  * \sa MRVL::CImageConvolution, MRVL
	  */
	class CGaussianConvolutionKernel
	{
		friend class CImageConvolution;

	private:
		/** Precomputed values
		  */
		std::vector<float>	m_kernel;

		/** The length of the vectors "m_gaussKernel" and "m_gaussDerivKernel"
		  */
		unsigned int		m_kernelSize;

		/** The gaussian sigma
		  */
		float				m_sigma;

		/** This is "true" if the kernel is a DOG, or false on a Gaussian kernel.
		  */
		bool				m_isDOG;

		/** Build the precomputed tables.
		  */
		void 		buildPrecomputedKernels( float sigma, bool isDOG );

	public:

		/** The constructor is given the "sigma" value (in pixels) to precompute the gaussian and DOG lookup tables.
		  * \param sigma The sigma value of the Gaussian.
		  * \param isDOG Set to false to obtain a Gaussian kernel, or false to obtain a DOG filter.
		  * \sa MRVL::CImageConvolution
		  */
		CGaussianConvolutionKernel( float sigma, bool isDOG );

		/** Returns the size of the window (number of samples) of the kernel.
		  */
		unsigned int  getKernelSize();

		/** Changes the sigma:
		  */
		void 		changeSigma( float sigma );

	};	// End of class

} // End of namespace


#endif
