/* -*- C++ -*- ImplRepoC.h,v 1.6 2000/03/03 02:53:23 parsons Exp */

// ******  Code generated by the The ACE ORB (TAO) IDL Compiler *******
// TAO and the TAO IDL Compiler have been developed by the Center for
// Distributed Object Computing at Washington University, St. Louis.
//
// Information about TAO is available at:
//                 http://www.cs.wustl.edu/~schmidt/TAO.html

#ifndef _TAO_IDL_IMPLREPOC_H_
#define _TAO_IDL_IMPLREPOC_H_

#include "tao/Object.h"
#include "tao/Managed_Types.h"
#include "tao/POAC.h"
#include "tao/Servant_Base.h"
#include "tao/Operation_Table.h"
#include "tao/Stub.h"
#include "tao/ORB_Core.h"
#include "tao/Server_Request.h"
#include "tao/NVList.h"
#include "tao/Object_Adapter.h"
#include "tao/Invocation.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#if defined (ACE_HAS_MINIMUM_IOSTREAMH_INCLUSION)
#include "ace/streams.h"
#endif /* ACE_HAS_MINIMUM_IOSTREAMH_INCLUSION */


#if defined (TAO_EXPORT_MACRO)
#undef TAO_EXPORT_MACRO
#endif
#define TAO_EXPORT_MACRO TAO_Export

#if defined (TAO_EXPORT_NESTED_CLASSES)
#  if defined (TAO_EXPORT_NESTED_MACRO)
#    undef TAO_EXPORT_NESTED_MACRO
#  endif /* defined (TAO_EXPORT_NESTED_MACRO) */
#  define TAO_EXPORT_NESTED_MACRO TAO_Export
#endif /* TAO_EXPORT_NESTED_CLASSES */

#if defined(_MSC_VER)
#if (_MSC_VER >= 1200)
#pragma warning(push)
#endif /* _MSC_VER >= 1200 */
#pragma warning(disable:4250)
#endif /* _MSC_VER */

TAO_NAMESPACE  ImplementationRepository
{

#if !defined (_IMPLEMENTATIONREPOSITORY_SERVEROBJECT___PTR_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVEROBJECT___PTR_CH_

  class ServerObject;
  typedef ServerObject *ServerObject_ptr;

#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVEROBJECT___VAR_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVEROBJECT___VAR_CH_

  class TAO_Export ServerObject_var
  {
  public:
    ServerObject_var (void); // default constructor
    ServerObject_var (ServerObject_ptr);
    ServerObject_var (const ServerObject_var &); // copy constructor
    ~ServerObject_var (void); // destructor

    ServerObject_var &operator= (ServerObject_ptr);
    ServerObject_var &operator= (const ServerObject_var &);
    ServerObject_ptr operator-> (void) const;

    operator const ServerObject_ptr &() const;
    operator ServerObject_ptr &();
    // in, inout, out, _retn
    ServerObject_ptr in (void) const;
    ServerObject_ptr &inout (void);
    ServerObject_ptr &out (void);
    ServerObject_ptr _retn (void);
    ServerObject_ptr ptr (void) const;

  private:
    ServerObject_ptr ptr_;
  };


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVEROBJECT___OUT_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVEROBJECT___OUT_CH_

  class TAO_Export ServerObject_out
  {
  public:
    ServerObject_out (ServerObject_ptr &);
    ServerObject_out (ServerObject_var &);
    ServerObject_out (const ServerObject_out &);
    ServerObject_out &operator= (const ServerObject_out &);
    ServerObject_out &operator= (const ServerObject_var &);
    ServerObject_out &operator= (ServerObject_ptr);
    operator ServerObject_ptr &();
    ServerObject_ptr &ptr (void);
    ServerObject_ptr operator-> (void);

  private:
    ServerObject_ptr &ptr_;
  };


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVEROBJECT_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVEROBJECT_CH_

class TAO_Export ServerObject : public virtual ACE_CORBA_1 (Object)
  {
  public:
  #if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef ServerObject_ptr _ptr_type;
    typedef ServerObject_var _var_type;
  #endif /* ! __GNUC__ || g++ >= 2.8 */

    // the static operations
    static ServerObject_ptr _duplicate (ServerObject_ptr obj);
    static ServerObject_ptr _narrow (
        CORBA::Object_ptr obj,
        CORBA::Environment &env =
          TAO_default_environment ()
      );
    static ServerObject_ptr _unchecked_narrow (
        CORBA::Object_ptr obj,
        CORBA::Environment &env =
          TAO_default_environment ()
      );
    static ServerObject_ptr _nil (void)
      {
        return (ImplementationRepository::ServerObject_ptr)0;
      }

    virtual void ping (
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      )
      ACE_THROW_SPEC ((
        CORBA::SystemException
      ));

    virtual void shutdown (
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      )
      ACE_THROW_SPEC ((
        CORBA::SystemException
      ));

    virtual CORBA::Boolean _is_a (
        const CORBA::Char *type_id,
        CORBA::Environment &env =
          TAO_default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;

  protected:
    ServerObject (void);
    ServerObject (TAO_Stub *objref,
        TAO_ServantBase *_tao_servant = 0,
        CORBA::Boolean _tao_collocated = 0
      );
    virtual ~ServerObject (void);
  private:
    ServerObject (const ServerObject &);
    void operator= (const ServerObject &);
};

class TAO_ImplementationRepository_ServerObject_Default_Proxy_Factory
{
public:

  TAO_ImplementationRepository_ServerObject_Default_Proxy_Factory (int register_proxy_factory = 1);

  virtual ~TAO_ImplementationRepository_ServerObject_Default_Proxy_Factory (void);

  virtual ImplementationRepository::ServerObject_ptr create_proxy (
      ImplementationRepository::ServerObject_ptr proxy,
      CORBA::Environment &env =
        TAO_default_environment ()
    );
};

class TAO_ImplementationRepository_ServerObject_Proxy_Factory_Adapter
{
public:

  friend class ACE_Singleton<TAO_ImplementationRepository_ServerObject_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX>;

  int register_proxy_factory (
      TAO_ImplementationRepository_ServerObject_Default_Proxy_Factory *df,
      CORBA::Environment &env =
        TAO_default_environment ()
    );

  int unregister_proxy_factory (
      CORBA::Environment &env =
        TAO_default_environment ()
    );

  ImplementationRepository::ServerObject_ptr create_proxy (
      ImplementationRepository::ServerObject_ptr proxy,
      CORBA::Environment &env =
        TAO_default_environment ()
    );

protected:
  TAO_ImplementationRepository_ServerObject_Proxy_Factory_Adapter (void);
  ~TAO_ImplementationRepository_ServerObject_Proxy_Factory_Adapter (void);
  TAO_ImplementationRepository_ServerObject_Proxy_Factory_Adapter &operator= (
      const TAO_ImplementationRepository_ServerObject_Proxy_Factory_Adapter &
    );
  TAO_ImplementationRepository_ServerObject_Default_Proxy_Factory *proxy_factory_;
  int delete_proxy_factory_;
  ACE_SYNCH_RECURSIVE_MUTEX lock_;
  };

  typedef ACE_Singleton<TAO_ImplementationRepository_ServerObject_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX> TAO_ImplementationRepository_ServerObject_PROXY_FACTORY_ADAPTER;
  class TAO_ImplementationRepository_ServerObject_Smart_Proxy_Base : public virtual ImplementationRepository::ServerObject
  {
  public:
    TAO_ImplementationRepository_ServerObject_Smart_Proxy_Base (ImplementationRepository::ServerObject_ptr proxy);
    ~TAO_ImplementationRepository_ServerObject_Smart_Proxy_Base (void);
      virtual void ping (
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual void shutdown (
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

private:
  ImplementationRepository::ServerObject_var base_proxy_;
};


#endif /* end #if !defined */

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_ServerObject;

struct EnvironmentVariable;
class EnvironmentVariable_var;
typedef EnvironmentVariable* EnvironmentVariable_ptr;

struct TAO_Export EnvironmentVariable
{

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef EnvironmentVariable_ptr _ptr_type;
  typedef EnvironmentVariable_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

  TAO_String_Manager name;
  TAO_String_Manager value;
};

class TAO_Export EnvironmentVariable_var
{
public:
  EnvironmentVariable_var (void); // default constructor
  EnvironmentVariable_var (EnvironmentVariable *);
  EnvironmentVariable_var (const EnvironmentVariable_var &); // copy constructor
  ~EnvironmentVariable_var (void); // destructor

  EnvironmentVariable_var &operator= (EnvironmentVariable *);
  EnvironmentVariable_var &operator= (const EnvironmentVariable_var &);
  EnvironmentVariable *operator-> (void);
  const EnvironmentVariable *operator-> (void) const;

  operator const EnvironmentVariable &() const;
  operator EnvironmentVariable &();
  operator EnvironmentVariable &() const;
  // in, inout, out, _retn
  const EnvironmentVariable &in (void) const;
  EnvironmentVariable &inout (void);
  EnvironmentVariable *&out (void);
  EnvironmentVariable *_retn (void);
  EnvironmentVariable *ptr (void) const;

private:
  EnvironmentVariable *ptr_;
};

class TAO_Export EnvironmentVariable_out
{
public:
  EnvironmentVariable_out (EnvironmentVariable *&);
  EnvironmentVariable_out (EnvironmentVariable_var &);
  EnvironmentVariable_out (const EnvironmentVariable_out &);
  EnvironmentVariable_out &operator= (const EnvironmentVariable_out &);
  EnvironmentVariable_out &operator= (EnvironmentVariable *);
  operator EnvironmentVariable *&();
  EnvironmentVariable *&ptr (void);
  EnvironmentVariable *operator-> (void);

private:
  EnvironmentVariable *&ptr_;
  // assignment from T_var not allowed
  void operator= (const EnvironmentVariable_var &);
};

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_EnvironmentVariable;

typedef char * Address;
typedef CORBA::String_var Address_var;
typedef CORBA::String_out Address_out;
TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_Address;


#if !defined (TAO_USE_SEQUENCE_TEMPLATES)

#if !defined (__TAO_UNBOUNDED_SEQUENCE_IMPLEMENTATIONREPOSITORY_ENVIRONMENTLIST_CH_)
#define __TAO_UNBOUNDED_SEQUENCE_IMPLEMENTATIONREPOSITORY_ENVIRONMENTLIST_CH_

  class TAO_EXPORT_NESTED_MACRO _TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList : public TAO_Unbounded_Base_Sequence
  {
  public:
    // = Initialization and termination methods.

    _TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList (void); // Default constructor.
    _TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList (CORBA::ULong maximum);
    _TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList (CORBA::ULong maximum,
      CORBA::ULong length,
      EnvironmentVariable *data,
      CORBA::Boolean release = 0);
    _TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList (const _TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList &rhs);
    _TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList &operator= (const _TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList &rhs);
    virtual ~_TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList (void); // Dtor.
    // = Accessors.
    EnvironmentVariable &operator[] (CORBA::ULong i);
    const EnvironmentVariable &operator[] (CORBA::ULong i) const;
    // = Static operations.
    static EnvironmentVariable *allocbuf (CORBA::ULong size);
    static void freebuf (EnvironmentVariable *buffer);
    virtual void _allocate_buffer (CORBA::ULong length);
    virtual void _deallocate_buffer (void);
    // Implement the TAO_Base_Sequence methods (see Sequence.h)

    EnvironmentVariable *get_buffer (CORBA::Boolean orphan = 0);
    const EnvironmentVariable *get_buffer (void) const;
    void replace (CORBA::ULong max,
      CORBA::ULong length,
      EnvironmentVariable *data,
      CORBA::Boolean release);
  };

#endif /* end #if !defined */


#endif /* !TAO_USE_SEQUENCE_TEMPLATES */

#if !defined (_IMPLEMENTATIONREPOSITORY_ENVIRONMENTLIST_CH_)
#define _IMPLEMENTATIONREPOSITORY_ENVIRONMENTLIST_CH_

class EnvironmentList;
class EnvironmentList_var;
typedef EnvironmentList* EnvironmentList_ptr;

// *************************************************************
// EnvironmentList
// *************************************************************

class TAO_Export EnvironmentList : public
#if !defined (TAO_USE_SEQUENCE_TEMPLATES)
  _TAO_Unbounded_Sequence_ImplementationRepository_EnvironmentList
#else /* TAO_USE_SEQUENCE_TEMPLATES */
  TAO_Unbounded_Sequence<EnvironmentVariable>
#endif /* !TAO_USE_SEQUENCE_TEMPLATES */
{
public:
  EnvironmentList (void); // default ctor
  EnvironmentList (CORBA::ULong max); // uses max size
  EnvironmentList (
    CORBA::ULong max,
    CORBA::ULong length,
    EnvironmentVariable *buffer,
    CORBA::Boolean release=0
  );
  EnvironmentList (const EnvironmentList &); // copy ctor
  ~EnvironmentList (void); // dtor

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef EnvironmentList_ptr _ptr_type;
  typedef EnvironmentList_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

};

#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ENVIRONMENTLIST___VAR_CH_)
#define _IMPLEMENTATIONREPOSITORY_ENVIRONMENTLIST___VAR_CH_

// *************************************************************
// class ImplementationRepository::EnvironmentList_var
// *************************************************************

class TAO_Export EnvironmentList_var
{
public:
  EnvironmentList_var (void); // default constructor
  EnvironmentList_var (EnvironmentList *);
  EnvironmentList_var (const EnvironmentList_var &); // copy constructor
  ~EnvironmentList_var (void); // destructor

  EnvironmentList_var &operator= (EnvironmentList *);
  EnvironmentList_var &operator= (const EnvironmentList_var &);
  EnvironmentList *operator-> (void);
  const EnvironmentList *operator-> (void) const;

  operator const EnvironmentList &() const;
  operator EnvironmentList &();
  operator EnvironmentList &() const;
  EnvironmentVariable &operator[] (CORBA::ULong index);
  // in, inout, out, _retn
  const EnvironmentList &in (void) const;
  EnvironmentList &inout (void);
  EnvironmentList *&out (void);
  EnvironmentList *_retn (void);
  EnvironmentList *ptr (void) const;

private:
  EnvironmentList *ptr_;
};


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ENVIRONMENTLIST___OUT_CH_)
#define _IMPLEMENTATIONREPOSITORY_ENVIRONMENTLIST___OUT_CH_

class TAO_Export EnvironmentList_out
{
public:
  EnvironmentList_out (EnvironmentList *&);
  EnvironmentList_out (EnvironmentList_var &);
  EnvironmentList_out (const EnvironmentList_out &);
  EnvironmentList_out &operator= (const EnvironmentList_out &);
  EnvironmentList_out &operator= (EnvironmentList *);
  operator EnvironmentList *&();
  EnvironmentList *&ptr (void);
  EnvironmentList *operator-> (void);
  EnvironmentVariable &operator[] (CORBA::ULong index);

private:
  EnvironmentList *&ptr_;
  // assignment from T_var not allowed
  void operator= (const EnvironmentList_var &);
};


#endif /* end #if !defined */

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_EnvironmentList;

enum ActivationMode
{
    NORMAL,
    MANUAL,
    PER_CLIENT,
    AUTO_START,
    ActivationMode_TAO_ENUM_32BIT_ENFORCER = 0x7FFFFFFF
};
typedef ActivationMode &ActivationMode_out;
TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_ActivationMode;

struct StartupOptions;
class StartupOptions_var;
typedef StartupOptions* StartupOptions_ptr;

struct TAO_Export StartupOptions
{

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef StartupOptions_ptr _ptr_type;
  typedef StartupOptions_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

  TAO_String_Manager command_line;
  ImplementationRepository::EnvironmentList environment;
  TAO_String_Manager working_directory;
  ImplementationRepository::ActivationMode activation;
};

class TAO_Export StartupOptions_var
{
public:
  StartupOptions_var (void); // default constructor
  StartupOptions_var (StartupOptions *);
  StartupOptions_var (const StartupOptions_var &); // copy constructor
  ~StartupOptions_var (void); // destructor

  StartupOptions_var &operator= (StartupOptions *);
  StartupOptions_var &operator= (const StartupOptions_var &);
  StartupOptions *operator-> (void);
  const StartupOptions *operator-> (void) const;

  operator const StartupOptions &() const;
  operator StartupOptions &();
  operator StartupOptions &() const;
  // in, inout, out, _retn
  const StartupOptions &in (void) const;
  StartupOptions &inout (void);
  StartupOptions *&out (void);
  StartupOptions *_retn (void);
  StartupOptions *ptr (void) const;

private:
  StartupOptions *ptr_;
};

class TAO_Export StartupOptions_out
{
public:
  StartupOptions_out (StartupOptions *&);
  StartupOptions_out (StartupOptions_var &);
  StartupOptions_out (const StartupOptions_out &);
  StartupOptions_out &operator= (const StartupOptions_out &);
  StartupOptions_out &operator= (StartupOptions *);
  operator StartupOptions *&();
  StartupOptions *&ptr (void);
  StartupOptions *operator-> (void);

private:
  StartupOptions *&ptr_;
  // assignment from T_var not allowed
  void operator= (const StartupOptions_var &);
};

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_StartupOptions;

struct ServerInformation;
class ServerInformation_var;
typedef ServerInformation* ServerInformation_ptr;

struct TAO_Export ServerInformation
{

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef ServerInformation_ptr _ptr_type;
  typedef ServerInformation_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

  TAO_String_Manager logical_server;
  TAO_String_Manager server;
  ImplementationRepository::StartupOptions startup;
  TAO_String_Manager location;
};

class TAO_Export ServerInformation_var
{
public:
  ServerInformation_var (void); // default constructor
  ServerInformation_var (ServerInformation *);
  ServerInformation_var (const ServerInformation_var &); // copy constructor
  ~ServerInformation_var (void); // destructor

  ServerInformation_var &operator= (ServerInformation *);
  ServerInformation_var &operator= (const ServerInformation_var &);
  ServerInformation *operator-> (void);
  const ServerInformation *operator-> (void) const;

  operator const ServerInformation &() const;
  operator ServerInformation &();
  operator ServerInformation &() const;
  // in, inout, out, _retn
  const ServerInformation &in (void) const;
  ServerInformation &inout (void);
  ServerInformation *&out (void);
  ServerInformation *_retn (void);
  ServerInformation *ptr (void) const;

private:
  ServerInformation *ptr_;
};

class TAO_Export ServerInformation_out
{
public:
  ServerInformation_out (ServerInformation *&);
  ServerInformation_out (ServerInformation_var &);
  ServerInformation_out (const ServerInformation_out &);
  ServerInformation_out &operator= (const ServerInformation_out &);
  ServerInformation_out &operator= (ServerInformation *);
  operator ServerInformation *&();
  ServerInformation *&ptr (void);
  ServerInformation *operator-> (void);

private:
  ServerInformation *&ptr_;
  // assignment from T_var not allowed
  void operator= (const ServerInformation_var &);
};

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_ServerInformation;


#if !defined (TAO_USE_SEQUENCE_TEMPLATES)

#if !defined (__TAO_UNBOUNDED_SEQUENCE_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONLIST_CH_)
#define __TAO_UNBOUNDED_SEQUENCE_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONLIST_CH_

  class TAO_EXPORT_NESTED_MACRO _TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList : public TAO_Unbounded_Base_Sequence
  {
  public:
    // = Initialization and termination methods.

    _TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList (void); // Default constructor.
    _TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList (CORBA::ULong maximum);
    _TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList (CORBA::ULong maximum,
      CORBA::ULong length,
      ServerInformation *data,
      CORBA::Boolean release = 0);
    _TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList (const _TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList &rhs);
    _TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList &operator= (const _TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList &rhs);
    virtual ~_TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList (void); // Dtor.
    // = Accessors.
    ServerInformation &operator[] (CORBA::ULong i);
    const ServerInformation &operator[] (CORBA::ULong i) const;
    // = Static operations.
    static ServerInformation *allocbuf (CORBA::ULong size);
    static void freebuf (ServerInformation *buffer);
    virtual void _allocate_buffer (CORBA::ULong length);
    virtual void _deallocate_buffer (void);
    // Implement the TAO_Base_Sequence methods (see Sequence.h)

    ServerInformation *get_buffer (CORBA::Boolean orphan = 0);
    const ServerInformation *get_buffer (void) const;
    void replace (CORBA::ULong max,
      CORBA::ULong length,
      ServerInformation *data,
      CORBA::Boolean release);
  };

#endif /* end #if !defined */


#endif /* !TAO_USE_SEQUENCE_TEMPLATES */

#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONLIST_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONLIST_CH_

class ServerInformationList;
class ServerInformationList_var;
typedef ServerInformationList* ServerInformationList_ptr;

// *************************************************************
// ServerInformationList
// *************************************************************

class TAO_Export ServerInformationList : public
#if !defined (TAO_USE_SEQUENCE_TEMPLATES)
  _TAO_Unbounded_Sequence_ImplementationRepository_ServerInformationList
#else /* TAO_USE_SEQUENCE_TEMPLATES */
  TAO_Unbounded_Sequence<ServerInformation>
#endif /* !TAO_USE_SEQUENCE_TEMPLATES */
{
public:
  ServerInformationList (void); // default ctor
  ServerInformationList (CORBA::ULong max); // uses max size
  ServerInformationList (
    CORBA::ULong max,
    CORBA::ULong length,
    ServerInformation *buffer,
    CORBA::Boolean release=0
  );
  ServerInformationList (const ServerInformationList &); // copy ctor
  ~ServerInformationList (void); // dtor

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef ServerInformationList_ptr _ptr_type;
  typedef ServerInformationList_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

};

#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONLIST___VAR_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONLIST___VAR_CH_

// *************************************************************
// class ImplementationRepository::ServerInformationList_var
// *************************************************************

class TAO_Export ServerInformationList_var
{
public:
  ServerInformationList_var (void); // default constructor
  ServerInformationList_var (ServerInformationList *);
  ServerInformationList_var (const ServerInformationList_var &); // copy constructor
  ~ServerInformationList_var (void); // destructor

  ServerInformationList_var &operator= (ServerInformationList *);
  ServerInformationList_var &operator= (const ServerInformationList_var &);
  ServerInformationList *operator-> (void);
  const ServerInformationList *operator-> (void) const;

  operator const ServerInformationList &() const;
  operator ServerInformationList &();
  operator ServerInformationList &() const;
  ServerInformation &operator[] (CORBA::ULong index);
  // in, inout, out, _retn
  const ServerInformationList &in (void) const;
  ServerInformationList &inout (void);
  ServerInformationList *&out (void);
  ServerInformationList *_retn (void);
  ServerInformationList *ptr (void) const;

private:
  ServerInformationList *ptr_;
};


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONLIST___OUT_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONLIST___OUT_CH_

class TAO_Export ServerInformationList_out
{
public:
  ServerInformationList_out (ServerInformationList *&);
  ServerInformationList_out (ServerInformationList_var &);
  ServerInformationList_out (const ServerInformationList_out &);
  ServerInformationList_out &operator= (const ServerInformationList_out &);
  ServerInformationList_out &operator= (ServerInformationList *);
  operator ServerInformationList *&();
  ServerInformationList *&ptr (void);
  ServerInformationList *operator-> (void);
  ServerInformation &operator[] (CORBA::ULong index);

private:
  ServerInformationList *&ptr_;
  // assignment from T_var not allowed
  void operator= (const ServerInformationList_var &);
};


#endif /* end #if !defined */

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_ServerInformationList;

class ServerInformationIterator;

#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___PTR_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___PTR_CH_

typedef ServerInformationIterator *ServerInformationIterator_ptr;

#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___VAR_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___VAR_CH_

class TAO_Export ServerInformationIterator_var
{
public:
  ServerInformationIterator_var (void); // default constructor
  ServerInformationIterator_var (ServerInformationIterator_ptr);
  ServerInformationIterator_var (const ServerInformationIterator_var &); // copy constructor
  ~ServerInformationIterator_var (void); // destructor

  ServerInformationIterator_var &operator= (ServerInformationIterator_ptr);
  ServerInformationIterator_var &operator= (const ServerInformationIterator_var &);
  ServerInformationIterator_ptr operator-> (void) const;

  operator const ServerInformationIterator_ptr &() const;
  operator ServerInformationIterator_ptr &();
  // in, inout, out, _retn
  ServerInformationIterator_ptr in (void) const;
  ServerInformationIterator_ptr &inout (void);
  ServerInformationIterator_ptr &out (void);
  ServerInformationIterator_ptr _retn (void);
  ServerInformationIterator_ptr ptr (void) const;

private:
  ServerInformationIterator_ptr ptr_;
};


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___OUT_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___OUT_CH_

class TAO_Export ServerInformationIterator_out
{
public:
  ServerInformationIterator_out (ServerInformationIterator_ptr &);
  ServerInformationIterator_out (ServerInformationIterator_var &);
  ServerInformationIterator_out (const ServerInformationIterator_out &);
  ServerInformationIterator_out &operator= (const ServerInformationIterator_out &);
  ServerInformationIterator_out &operator= (const ServerInformationIterator_var &);
  ServerInformationIterator_out &operator= (ServerInformationIterator_ptr);
  operator ServerInformationIterator_ptr &();
  ServerInformationIterator_ptr &ptr (void);
  ServerInformationIterator_ptr operator-> (void);

private:
  ServerInformationIterator_ptr &ptr_;
};


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION___PTR_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION___PTR_CH_

class Administration;
typedef Administration *Administration_ptr;

#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION___VAR_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION___VAR_CH_

class TAO_Export Administration_var
{
public:
  Administration_var (void); // default constructor
  Administration_var (Administration_ptr);
  Administration_var (const Administration_var &); // copy constructor
  ~Administration_var (void); // destructor

  Administration_var &operator= (Administration_ptr);
  Administration_var &operator= (const Administration_var &);
  Administration_ptr operator-> (void) const;

  operator const Administration_ptr &() const;
  operator Administration_ptr &();
  // in, inout, out, _retn
  Administration_ptr in (void) const;
  Administration_ptr &inout (void);
  Administration_ptr &out (void);
  Administration_ptr _retn (void);
  Administration_ptr ptr (void) const;

private:
  Administration_ptr ptr_;
};


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION___OUT_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION___OUT_CH_

class TAO_Export Administration_out
{
public:
  Administration_out (Administration_ptr &);
  Administration_out (Administration_var &);
  Administration_out (const Administration_out &);
  Administration_out &operator= (const Administration_out &);
  Administration_out &operator= (const Administration_var &);
  Administration_out &operator= (Administration_ptr);
  operator Administration_ptr &();
  Administration_ptr &ptr (void);
  Administration_ptr operator-> (void);

private:
  Administration_ptr &ptr_;
};


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION_CH_

class TAO_Export Administration : public virtual ACE_CORBA_1 (Object)
{
public:
#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef Administration_ptr _ptr_type;
  typedef Administration_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

  // the static operations
  static Administration_ptr _duplicate (Administration_ptr obj);
  static Administration_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &env =
        TAO_default_environment ()
    );
  static Administration_ptr _unchecked_narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &env =
        TAO_default_environment ()
    );
  static Administration_ptr _nil (void)
    {
      return (ImplementationRepository::Administration_ptr)0;
    }


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION_ALREADYREGISTERED___PTR_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION_ALREADYREGISTERED___PTR_CH_

  class AlreadyRegistered;
  typedef AlreadyRegistered *AlreadyRegistered_ptr;

#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION_ALREADYREGISTERED_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION_ALREADYREGISTERED_CH_

  class TAO_Export AlreadyRegistered : public CORBA::UserException
  {
  public:

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef AlreadyRegistered_ptr _ptr_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */


    AlreadyRegistered (void); // default ctor
    AlreadyRegistered (const AlreadyRegistered &); // copy ctor
    ~AlreadyRegistered (void); // dtor
    AlreadyRegistered &operator= (const AlreadyRegistered &);


    virtual void _raise (void);

    virtual void _tao_encode (TAO_OutputCDR &cdr,
                              CORBA::Environment &) const;
    virtual void _tao_decode (TAO_InputCDR &cdr,
                              CORBA::Environment &);

    static AlreadyRegistered *_narrow (CORBA::Exception *);


    // = TAO extension
    static CORBA::Exception *_alloc (void);

  }; // exception ImplementationRepository::Administration::AlreadyRegistered

    static CORBA::TypeCode_ptr _tc_AlreadyRegistered;


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION_CANNOTACTIVATE___PTR_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION_CANNOTACTIVATE___PTR_CH_

  class CannotActivate;
  typedef CannotActivate *CannotActivate_ptr;

#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION_CANNOTACTIVATE_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION_CANNOTACTIVATE_CH_

  class TAO_Export CannotActivate : public CORBA::UserException
  {
  public:

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef CannotActivate_ptr _ptr_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

    TAO_String_Manager reason;

    CannotActivate (void); // default ctor
    CannotActivate (const CannotActivate &); // copy ctor
    ~CannotActivate (void); // dtor
    CannotActivate &operator= (const CannotActivate &);


    virtual void _raise (void);

    virtual void _tao_encode (TAO_OutputCDR &cdr,
                              CORBA::Environment &) const;
    virtual void _tao_decode (TAO_InputCDR &cdr,
                              CORBA::Environment &);

    static CannotActivate *_narrow (CORBA::Exception *);

    CannotActivate (
      const char * _tao_reason
    );

    // = TAO extension
    static CORBA::Exception *_alloc (void);

  }; // exception ImplementationRepository::Administration::CannotActivate

    static CORBA::TypeCode_ptr _tc_CannotActivate;


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION_NOTFOUND___PTR_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION_NOTFOUND___PTR_CH_

  class NotFound;
  typedef NotFound *NotFound_ptr;

#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_ADMINISTRATION_NOTFOUND_CH_)
#define _IMPLEMENTATIONREPOSITORY_ADMINISTRATION_NOTFOUND_CH_

  class TAO_Export NotFound : public CORBA::UserException
  {
  public:

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef NotFound_ptr _ptr_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */


    NotFound (void); // default ctor
    NotFound (const NotFound &); // copy ctor
    ~NotFound (void); // dtor
    NotFound &operator= (const NotFound &);


    virtual void _raise (void);

    virtual void _tao_encode (TAO_OutputCDR &cdr,
                              CORBA::Environment &) const;
    virtual void _tao_decode (TAO_InputCDR &cdr,
                              CORBA::Environment &);

    static NotFound *_narrow (CORBA::Exception *);


    // = TAO extension
    static CORBA::Exception *_alloc (void);

  }; // exception ImplementationRepository::Administration::NotFound

    static CORBA::TypeCode_ptr _tc_NotFound;


#endif /* end #if !defined */

  virtual void activate_server (
      const char * server,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound,
      ImplementationRepository::Administration::CannotActivate
    ));

  virtual void register_server (
      const char * server,
      const ImplementationRepository::StartupOptions & options,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::AlreadyRegistered
    ));

  virtual void reregister_server (
      const char * server,
      const ImplementationRepository::StartupOptions & options,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual void remove_server (
      const char * server,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual void shutdown_server (
      const char * server,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual char * server_is_running (
      const char * server,
      const char * addr,
      ImplementationRepository::ServerObject_ptr server_object,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual void server_is_shutting_down (
      const char * server,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual void find (
      const char * server,
      ImplementationRepository::ServerInformation_out info,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual void list (
      CORBA::ULong how_many,
      ImplementationRepository::ServerInformationList_out server_list,
      ImplementationRepository::ServerInformationIterator_out server_iterator,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id,
      CORBA::Environment &env =
        TAO_default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

protected:
  Administration (void);
  Administration (TAO_Stub *objref,
      TAO_ServantBase *_tao_servant = 0,
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~Administration (void);
private:
  Administration (const Administration &);
  void operator= (const Administration &);
};

class TAO_ImplementationRepository_Administration_Default_Proxy_Factory
{
public:

  TAO_ImplementationRepository_Administration_Default_Proxy_Factory (int register_proxy_factory = 1);

  virtual ~TAO_ImplementationRepository_Administration_Default_Proxy_Factory (void);

  virtual ImplementationRepository::Administration_ptr create_proxy (
      ImplementationRepository::Administration_ptr proxy,
      CORBA::Environment &env =
        TAO_default_environment ()
    );
};

class TAO_ImplementationRepository_Administration_Proxy_Factory_Adapter
{
public:

  friend class ACE_Singleton<TAO_ImplementationRepository_Administration_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX>;

  int register_proxy_factory (
      TAO_ImplementationRepository_Administration_Default_Proxy_Factory *df,
      CORBA::Environment &env =
        TAO_default_environment ()
    );

  int unregister_proxy_factory (
      CORBA::Environment &env =
        TAO_default_environment ()
    );

  ImplementationRepository::Administration_ptr create_proxy (
      ImplementationRepository::Administration_ptr proxy,
      CORBA::Environment &env =
        TAO_default_environment ()
    );

protected:
  TAO_ImplementationRepository_Administration_Proxy_Factory_Adapter (void);
  ~TAO_ImplementationRepository_Administration_Proxy_Factory_Adapter (void);
  TAO_ImplementationRepository_Administration_Proxy_Factory_Adapter &operator= (
      const TAO_ImplementationRepository_Administration_Proxy_Factory_Adapter &
    );
  TAO_ImplementationRepository_Administration_Default_Proxy_Factory *proxy_factory_;
  int delete_proxy_factory_;
  ACE_SYNCH_RECURSIVE_MUTEX lock_;
  };

  typedef ACE_Singleton<TAO_ImplementationRepository_Administration_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX> TAO_ImplementationRepository_Administration_PROXY_FACTORY_ADAPTER;
  class TAO_ImplementationRepository_Administration_Smart_Proxy_Base : public virtual ImplementationRepository::Administration
  {
  public:
    TAO_ImplementationRepository_Administration_Smart_Proxy_Base (ImplementationRepository::Administration_ptr proxy);
    ~TAO_ImplementationRepository_Administration_Smart_Proxy_Base (void);
      virtual void activate_server (
      const char * server,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound,
      ImplementationRepository::Administration::CannotActivate
    ));

  virtual void register_server (
      const char * server,
      const ImplementationRepository::StartupOptions & options,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::AlreadyRegistered
    ));

  virtual void reregister_server (
      const char * server,
      const ImplementationRepository::StartupOptions & options,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual void remove_server (
      const char * server,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual void shutdown_server (
      const char * server,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual char * server_is_running (
      const char * server,
      const char * addr,
      ImplementationRepository::ServerObject_ptr server_object,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual void server_is_shutting_down (
      const char * server,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual void find (
      const char * server,
      ImplementationRepository::ServerInformation_out info,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      ImplementationRepository::Administration::NotFound
    ));

  virtual void list (
      CORBA::ULong how_many,
      ImplementationRepository::ServerInformationList_out server_list,
      ImplementationRepository::ServerInformationIterator_out server_iterator,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

private:
  ImplementationRepository::Administration_var base_proxy_;
};


#endif /* end #if !defined */

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_Administration;


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___PTR_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___PTR_CH_

class ServerInformationIterator;
typedef ServerInformationIterator *ServerInformationIterator_ptr;

#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___VAR_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___VAR_CH_

class TAO_Export ServerInformationIterator_var
{
public:
  ServerInformationIterator_var (void); // default constructor
  ServerInformationIterator_var (ServerInformationIterator_ptr);
  ServerInformationIterator_var (const ServerInformationIterator_var &); // copy constructor
  ~ServerInformationIterator_var (void); // destructor

  ServerInformationIterator_var &operator= (ServerInformationIterator_ptr);
  ServerInformationIterator_var &operator= (const ServerInformationIterator_var &);
  ServerInformationIterator_ptr operator-> (void) const;

  operator const ServerInformationIterator_ptr &() const;
  operator ServerInformationIterator_ptr &();
  // in, inout, out, _retn
  ServerInformationIterator_ptr in (void) const;
  ServerInformationIterator_ptr &inout (void);
  ServerInformationIterator_ptr &out (void);
  ServerInformationIterator_ptr _retn (void);
  ServerInformationIterator_ptr ptr (void) const;

private:
  ServerInformationIterator_ptr ptr_;
};


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___OUT_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR___OUT_CH_

class TAO_Export ServerInformationIterator_out
{
public:
  ServerInformationIterator_out (ServerInformationIterator_ptr &);
  ServerInformationIterator_out (ServerInformationIterator_var &);
  ServerInformationIterator_out (const ServerInformationIterator_out &);
  ServerInformationIterator_out &operator= (const ServerInformationIterator_out &);
  ServerInformationIterator_out &operator= (const ServerInformationIterator_var &);
  ServerInformationIterator_out &operator= (ServerInformationIterator_ptr);
  operator ServerInformationIterator_ptr &();
  ServerInformationIterator_ptr &ptr (void);
  ServerInformationIterator_ptr operator-> (void);

private:
  ServerInformationIterator_ptr &ptr_;
};


#endif /* end #if !defined */


#if !defined (_IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR_CH_)
#define _IMPLEMENTATIONREPOSITORY_SERVERINFORMATIONITERATOR_CH_

class TAO_Export ServerInformationIterator : public virtual ACE_CORBA_1 (Object)
{
public:
#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef ServerInformationIterator_ptr _ptr_type;
  typedef ServerInformationIterator_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

  // the static operations
  static ServerInformationIterator_ptr _duplicate (ServerInformationIterator_ptr obj);
  static ServerInformationIterator_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &env =
        TAO_default_environment ()
    );
  static ServerInformationIterator_ptr _unchecked_narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &env =
        TAO_default_environment ()
    );
  static ServerInformationIterator_ptr _nil (void)
    {
      return (ImplementationRepository::ServerInformationIterator_ptr)0;
    }

  virtual CORBA::Boolean next_n (
      CORBA::ULong how_many,
      ImplementationRepository::ServerInformationList_out server_list,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual void destroy (
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id,
      CORBA::Environment &env =
        TAO_default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

protected:
  ServerInformationIterator (void);
  ServerInformationIterator (TAO_Stub *objref,
      TAO_ServantBase *_tao_servant = 0,
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~ServerInformationIterator (void);
private:
  ServerInformationIterator (const ServerInformationIterator &);
  void operator= (const ServerInformationIterator &);
};

class TAO_ImplementationRepository_ServerInformationIterator_Default_Proxy_Factory
{
public:

  TAO_ImplementationRepository_ServerInformationIterator_Default_Proxy_Factory (int register_proxy_factory = 1);

  virtual ~TAO_ImplementationRepository_ServerInformationIterator_Default_Proxy_Factory (void);

  virtual ImplementationRepository::ServerInformationIterator_ptr create_proxy (
      ImplementationRepository::ServerInformationIterator_ptr proxy,
      CORBA::Environment &env =
        TAO_default_environment ()
    );
};

class TAO_ImplementationRepository_ServerInformationIterator_Proxy_Factory_Adapter
{
public:

  friend class ACE_Singleton<TAO_ImplementationRepository_ServerInformationIterator_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX>;

  int register_proxy_factory (
      TAO_ImplementationRepository_ServerInformationIterator_Default_Proxy_Factory *df,
      CORBA::Environment &env =
        TAO_default_environment ()
    );

  int unregister_proxy_factory (
      CORBA::Environment &env =
        TAO_default_environment ()
    );

  ImplementationRepository::ServerInformationIterator_ptr create_proxy (
      ImplementationRepository::ServerInformationIterator_ptr proxy,
      CORBA::Environment &env =
        TAO_default_environment ()
    );

protected:
  TAO_ImplementationRepository_ServerInformationIterator_Proxy_Factory_Adapter (void);
  ~TAO_ImplementationRepository_ServerInformationIterator_Proxy_Factory_Adapter (void);
  TAO_ImplementationRepository_ServerInformationIterator_Proxy_Factory_Adapter &operator= (
      const TAO_ImplementationRepository_ServerInformationIterator_Proxy_Factory_Adapter &
    );
  TAO_ImplementationRepository_ServerInformationIterator_Default_Proxy_Factory *proxy_factory_;
  int delete_proxy_factory_;
  ACE_SYNCH_RECURSIVE_MUTEX lock_;
  };

  typedef ACE_Singleton<TAO_ImplementationRepository_ServerInformationIterator_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX> TAO_ImplementationRepository_ServerInformationIterator_PROXY_FACTORY_ADAPTER;
  class TAO_ImplementationRepository_ServerInformationIterator_Smart_Proxy_Base : public virtual ImplementationRepository::ServerInformationIterator
  {
  public:
    TAO_ImplementationRepository_ServerInformationIterator_Smart_Proxy_Base (ImplementationRepository::ServerInformationIterator_ptr proxy);
    ~TAO_ImplementationRepository_ServerInformationIterator_Smart_Proxy_Base (void);
      virtual CORBA::Boolean next_n (
      CORBA::ULong how_many,
      ImplementationRepository::ServerInformationList_out server_list,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual void destroy (
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

private:
  ImplementationRepository::ServerInformationIterator_var base_proxy_;
};


#endif /* end #if !defined */

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_ServerInformationIterator;


}
TAO_NAMESPACE_CLOSE // module ImplementationRepository

extern TAO_Export ImplementationRepository::ServerObject_ptr (*_TAO_collocation_ImplementationRepository_ServerObject_Stub_Factory_function_pointer) (
    CORBA::Object_ptr obj
  );
// Any operators for interface ImplementationRepository::ServerObject
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::ServerObject_ptr);
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::ServerObject *&);
TAO_Export void operator<<= (CORBA::Any &, 
                             const ImplementationRepository::EnvironmentVariable &); // copying version
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::EnvironmentVariable*); // noncopying version
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::EnvironmentVariable *&); // deprecated
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       const ImplementationRepository::EnvironmentVariable *&);
TAO_Export void operator<<= (CORBA::Any &, 
                             const ImplementationRepository::EnvironmentList &); // copying version
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::EnvironmentList*); // noncopying version
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::EnvironmentList *&); // deprecated
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       const ImplementationRepository::EnvironmentList *&);
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::ActivationMode);
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::ActivationMode &);
TAO_Export void operator<<= (CORBA::Any &, 
                             const ImplementationRepository::StartupOptions &); // copying version
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::StartupOptions*); // noncopying version
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::StartupOptions *&); // deprecated
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       const ImplementationRepository::StartupOptions *&);
TAO_Export void operator<<= (CORBA::Any &, 
                             const ImplementationRepository::ServerInformation &); // copying version
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::ServerInformation*); // noncopying version
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::ServerInformation *&); // deprecated
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       const ImplementationRepository::ServerInformation *&);
TAO_Export void operator<<= (CORBA::Any &, 
                             const ImplementationRepository::ServerInformationList &); // copying version
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::ServerInformationList*); // noncopying version
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::ServerInformationList *&); // deprecated
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       const ImplementationRepository::ServerInformationList *&);
extern TAO_Export ImplementationRepository::Administration_ptr (*_TAO_collocation_ImplementationRepository_Administration_Stub_Factory_function_pointer) (
    CORBA::Object_ptr obj
  );
// Any operators for interface ImplementationRepository::Administration
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::Administration_ptr);
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::Administration *&);
TAO_Export void operator<<= (CORBA::Any &, 
                             const ImplementationRepository::Administration::AlreadyRegistered &); // copying version
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::Administration::AlreadyRegistered*); // noncopying version
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::Administration::AlreadyRegistered *&); // deprecated
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       const ImplementationRepository::Administration::AlreadyRegistered *&);
TAO_Export void operator<<= (CORBA::Any &, 
                             const ImplementationRepository::Administration::CannotActivate &); // copying version
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::Administration::CannotActivate*); // noncopying version
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::Administration::CannotActivate *&); // deprecated
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       const ImplementationRepository::Administration::CannotActivate *&);
TAO_Export void operator<<= (CORBA::Any &, 
                             const ImplementationRepository::Administration::NotFound &); // copying version
TAO_Export void operator<<= (CORBA::Any &, 
                             ImplementationRepository::Administration::NotFound*); // noncopying version
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       ImplementationRepository::Administration::NotFound *&); // deprecated
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, 
                                       const ImplementationRepository::Administration::NotFound *&);
extern TAO_Export ImplementationRepository::ServerInformationIterator_ptr (*_TAO_collocation_ImplementationRepository_ServerInformationIterator_Stub_Factory_function_pointer) (
    CORBA::Object_ptr obj
  );
// Any operators for interface ImplementationRepository::ServerInformationIterator
TAO_Export void operator<<= (CORBA::Any &, ImplementationRepository::ServerInformationIterator_ptr);
TAO_Export CORBA::Boolean operator>>= (const CORBA::Any &, ImplementationRepository::ServerInformationIterator *&);

#ifndef __ACE_INLINE__

TAO_Export CORBA::Boolean
operator<< (TAO_OutputCDR &, const ImplementationRepository::ServerObject_ptr );
TAO_Export CORBA::Boolean
operator>> (TAO_InputCDR &, ImplementationRepository::ServerObject_ptr &);
TAO_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const ImplementationRepository::EnvironmentVariable &);
TAO_Export CORBA::Boolean operator>> (TAO_InputCDR &, ImplementationRepository::EnvironmentVariable &);

#if !defined _TAO_CDR_OP_ImplementationRepository_EnvironmentList_H_
#define _TAO_CDR_OP_ImplementationRepository_EnvironmentList_H_

TAO_Export CORBA::Boolean operator<< (
    TAO_OutputCDR &,
    const ImplementationRepository::EnvironmentList &
  );
TAO_Export CORBA::Boolean operator>> (
    TAO_InputCDR &,
    ImplementationRepository::EnvironmentList &
  );

#endif /* _TAO_CDR_OP_ImplementationRepository_EnvironmentList_H_ */

TAO_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const ImplementationRepository::ActivationMode &); //
TAO_Export CORBA::Boolean operator>> (TAO_InputCDR &, ImplementationRepository::ActivationMode &);
TAO_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const ImplementationRepository::StartupOptions &);
TAO_Export CORBA::Boolean operator>> (TAO_InputCDR &, ImplementationRepository::StartupOptions &);
TAO_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const ImplementationRepository::ServerInformation &);
TAO_Export CORBA::Boolean operator>> (TAO_InputCDR &, ImplementationRepository::ServerInformation &);

#if !defined _TAO_CDR_OP_ImplementationRepository_ServerInformationList_H_
#define _TAO_CDR_OP_ImplementationRepository_ServerInformationList_H_

TAO_Export CORBA::Boolean operator<< (
    TAO_OutputCDR &,
    const ImplementationRepository::ServerInformationList &
  );
TAO_Export CORBA::Boolean operator>> (
    TAO_InputCDR &,
    ImplementationRepository::ServerInformationList &
  );

#endif /* _TAO_CDR_OP_ImplementationRepository_ServerInformationList_H_ */

TAO_Export CORBA::Boolean
operator<< (TAO_OutputCDR &, const ImplementationRepository::Administration_ptr );
TAO_Export CORBA::Boolean
operator>> (TAO_InputCDR &, ImplementationRepository::Administration_ptr &);
TAO_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const ImplementationRepository::Administration::AlreadyRegistered &);
TAO_Export CORBA::Boolean operator>> (TAO_InputCDR &, ImplementationRepository::Administration::AlreadyRegistered &);

# if !defined (ACE_LACKS_IOSTREAM_TOTALLY)

TAO_Export ostream& operator<< (ostream &, const ImplementationRepository::Administration::AlreadyRegistered &);

# endif /* ACE_LACKS_IOSTREAM_TOTALLY */
TAO_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const ImplementationRepository::Administration::CannotActivate &);
TAO_Export CORBA::Boolean operator>> (TAO_InputCDR &, ImplementationRepository::Administration::CannotActivate &);

# if !defined (ACE_LACKS_IOSTREAM_TOTALLY)

TAO_Export ostream& operator<< (ostream &, const ImplementationRepository::Administration::CannotActivate &);

# endif /* ACE_LACKS_IOSTREAM_TOTALLY */
TAO_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const ImplementationRepository::Administration::NotFound &);
TAO_Export CORBA::Boolean operator>> (TAO_InputCDR &, ImplementationRepository::Administration::NotFound &);

# if !defined (ACE_LACKS_IOSTREAM_TOTALLY)

TAO_Export ostream& operator<< (ostream &, const ImplementationRepository::Administration::NotFound &);

# endif /* ACE_LACKS_IOSTREAM_TOTALLY */
TAO_Export CORBA::Boolean
operator<< (TAO_OutputCDR &, const ImplementationRepository::ServerInformationIterator_ptr );
TAO_Export CORBA::Boolean
operator>> (TAO_InputCDR &, ImplementationRepository::ServerInformationIterator_ptr &);

#endif /* __ACE_INLINE__ */


#if defined (__ACE_INLINE__)
#include "ImplRepoC.i"
#endif /* defined INLINE */

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
#pragma warning(pop)
#endif /* _MSC_VER */

#endif /* ifndef */
