/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef MRPT_CONFIG_H
#define MRPT_CONFIG_H

/** A string with the 3 digits version number of MRPT - This is intended for 
  *  autolinking pragmas only, such as they know the complete name of DLLs.
  * This is only for Windows. In Unix it should be an empty string.
  * \sa MRPT_VERSION in <mrpt/version.h>
  */
#define MRPT_VERSION_POSTFIX "070"


/** If defined, security checks (ASSERT_'s) will be performed in many MRPT classes even
  *  if "_DEBUG" is not declared, which is then the default behavior.
  */
#define MRPT_ALWAYS_CHECKS_DEBUG                     0
#define MRPT_ALWAYS_CHECKS_DEBUG_MATRICES            1


/** MRPT_BUILT_AS_DLL is defined only if MRPT has been built
  *   as a shared library (.dll/.so) vs. a static library (.lib/.a).
  *  Additionally, MRPT_EXPORTS will be defined only when compiling
  *   the DLLs, not when the user imports them.
  */
#define MRPT_BUILT_AS_DLL

/** Includes the OpenCV library, required for image manipulation.
  * \sa CImageGrabber_OpenCV
  */
#define MRPT_HAS_OPENCV          1

// Version as text:
#define MRPT_OPENCV_VERSION      "1.0.0"

// Version as hexadecimal number: eg. 1.0.0 -> 0x100
#define MRPT_OPENCV_VERSION_NUM  0x100


/** Includes OpenGL & GLUT libraries, required for CDisplayWindows3D to work.
  */
#define MRPT_HAS_OPENGL_GLUT      1

/** For Windows with freeglut, use Static built-in library.
  */
#define FREEGLUT_STATIC


/** Define for including Bumblebee interface through the vendor's proprietary API, which enables the definition of some classes in the MRVL namespace.
  * \sa CStereoGrabber_Bumblebee
  */
#define MRPT_HAS_BUMBLEBEE        0

/** The file ftdi.h exists (Linux only)
  */
#define MRPT_HAS_FTDI             1

/** wxWidgets is present in the system (required for UTILS::CDisplayWindow, etc.)
  */
#define MRPT_HAS_WXWIDGETS        1

/** Has MRPT libjpeg? And whether it's in the system (Linux) or built-in (Windows, some rare cases in Linux).
  */
#define MRPT_HAS_JPEG             1
#define MRPT_HAS_JPEG_SYSTEM      0

/** For Windows and Debug config. only, whether to include the Visual Leak Detector:
  */
#define MRPT_HAS_VLD              0

#if defined(_WIN32) || defined(_WIN32_)  || defined(WIN32) || defined(_WIN64)
    #define MRPT_OS_WINDOWS
#else
#if defined(unix) || defined(__unix__) || defined(__unix)
    #define MRPT_OS_LINUX
#else
    #error Unsupported platform (Found neither _WIN32_ nor __unix__)
#endif
#endif

/** The size of cells in mrpt::slam::COccupancyGridMap2D
  */
#define	OCCUPANCY_GRIDMAP_CELL_SIZE_8BITS


/** Set to 0 to disable MRPT_TRY_START/MRPT_TRY_END blocks. Not recommended but for intensively tested programs only.
  */
#define MRPT_HAS_STACKED_EXCEPTIONS 1

/** Enable Katakana, Hiragana & Kanji character sets in UTILS::CMRPTCanvas.
  *  Disable this to save executable sizes if these fonts will be not used.
  */
#define MRPT_HAS_ASIAN_FONTS 1

/** Set to 0 to disable ASSERT_ statements. Not recommended but for intensively tested programs only.
  */
#define MRPT_HAS_ASSERT 1

/** Only for Linux: the inotify kernel module has been found. Requires kernel 2.6.13.
  */
#define MRPT_HAS_INOTIFY 0

/** The architecture is 32 or 64 bit wordsize:
  */
#define MRPT_WORD_SIZE	32

/** Use optimized functions with the SSE2 machine instructions set
 */
#if defined WIN32 && (!defined WIN64 || defined EM64T) && \
 (_MSC_VER >= 1400) || (defined __SSE2__ && defined __GNUC__ && __GNUC__ >= 4)
	#define MRPT_HAS_SSE2  1
#else
	#define MRPT_HAS_SSE2  0
#endif

/** Whether to include the ActivMedia Robotics ARIA:
  */
#define MRPT_HAS_ARIA 1

/** Whether to include the xSens MTi device interface:
  */
#define MRPT_HAS_xSENS 1

/** Whether to compile support for .gz compressed I/O streams:
  */
#define MRPT_HAS_GZ_STREAMS 1

/** Whether Boost is installed in the system.
  */
#define MRPT_HAS_BOOST 1

/** Whether stxxl is installed in the system.
  */
#define MRPT_HAS_STXXL 0

/** Whether ZLIB is present.
  */
#define MRPT_HAS_ZLIB 1
#define MRPT_HAS_ZLIB_SYSTEM 0


/** Whether libdc1394-2 is installed in the system.
  */
#define MRPT_HAS_LIBDC1394_2 0

/** Whether ffmpeg C libraries are installed in the system or 
    (in win32), their precompiled libraries.
  */
#define MRPT_HAS_FFMPEG 0

/** Whether MRPT is compiled with the "mrpt-sift-hess" library.
  *  This is always 0 in Debian due to a legal issue with the SIFT
  *   descriptor and its pending patent.
  */
#define MRPT_HAS_SIFT_HESS 1

/** Use only when compiling MRPT for BABEL releases. This ensures users
  *  will design application threads through the BABEL design system only.
  */
#define MRPT_HAS_NO_THREADS  1

/** Are we in a big-endian system? (Intel, amd, etc.. are little-endian)
  */
#define MRPT_IS_BIG_ENDIAN 0


/** Standard headers */
#ifndef HAVE_INTTYPES_H
/* #undef HAVE_INTTYPES_H */
#endif

#ifndef HAVE_WINSOCK2_H
#define HAVE_WINSOCK2_H 1
#endif

#ifndef HAVE_ALLOCA_H
/* #undef HAVE_ALLOCA_H */
#endif

/** Standard functions */
#ifndef HAVE_TIMEGM
/* #undef HAVE_TIMEGM */
#endif

#ifndef HAVE_ALLOCA
/* #undef HAVE_ALLOCA */
#endif

#ifndef HAVE_GETTID
/* #undef HAVE_GETTID */
#endif

#ifndef HAVE_OPENTHREAD
#define HAVE_OPENTHREAD
#endif

/* Standard types  */

#ifndef HAVE_LONG_DOUBLE
#define HAVE_LONG_DOUBLE
#endif

// -------------------------------
//			Some checks:
// -------------------------------
#if defined(MRPT_OS_WINDOWS) && defined(MRPT_OS_LINUX)
#error You cannot define both MRPT_OS_LINUX and MRPT_OS_WINDOWS!
#endif
#if !defined(MRPT_OS_WINDOWS) && !defined(MRPT_OS_LINUX)
#error You must define either MRPT_OS_LINUX or MRPT_OS_WINDOWS!
#endif


#endif

