# =========================================================================
#  The Mobile Robot Programming Toolkit (MRPT) CMake configuration file
#
#             ** File generated automatically, do not modify **
#
#  Usage from an external project: 
#   In your CMakeLists.txt, add these lines:
#
#    FIND_PACKAGE( MRPT REQUIRED )  # Default: links against mrpt-core only
#     or
#    FIND_PACKAGE( MRPT REQUIRED core hwdrivers ... )
#
#    TARGET_LINK_LIBRARIES(MY_TARGET_NAME ${MRPT_LIBS})
#
#   
#   The libraries ("components") which can be included are:
#     - core: The main library. It will be included by default.
#     - hmtslam        --> libmrpt-hmtslam
#     - hwdrivers      --> libmrpt-hwdrivers
#     - reactivenav    --> libmrpt-reactivenav
#     - monoslam       --> libmrpt-monoslam
#     - aria           --> libmrpt-aria
#
#   This file will define the following variables:
#      - MRPT_LIBS: The list of libraries to links against.
#
# =========================================================================

# Extract the directory where *this* file has been installed (determined at cmake run-time)
get_filename_component(THIS_MRPT_CONFIG_PATH "${CMAKE_CURRENT_LIST_FILE}" PATH)

# MRPT source dir
SET(MRPT_SOURCE_DIR "${THIS_MRPT_CONFIG_PATH}")

# MRPT binary dir
SET(MRPT_DIR "${THIS_MRPT_CONFIG_PATH}")

# MRPT include directory for "config.h"
SET(MRPT_CONFIG_DIR "${THIS_MRPT_CONFIG_PATH}/include/mrpt/mrpt-config/")

#MESSAGE(STATUS "MRPT_FIND_COMPONENTS: ${MRPT_FIND_COMPONENTS}")

# Warning on deprecated style:
IF(MRPT_USE_LIBS)
	MESSAGE(STATUS "***********************************************************************" )
	MESSAGE(STATUS "  MRPT WARNING: Deprecated variable MRPT_USE_LIBS. Replace your code:" )
	MESSAGE(STATUS "    SET(MRPT_USE_LIBS ${MRPT_USE_LIBS})" )
	MESSAGE(STATUS "    FIND_PACKAGE(MRPT REQUIRED)" )
	MESSAGE(STATUS "  By the new code:" )
	MESSAGE(STATUS "    FIND_PACKAGE(MRPT REQUIRED ${MRPT_USE_LIBS})" )
	MESSAGE(STATUS "***********************************************************************" )

	LIST(APPEND MRPT_FIND_COMPONENTS ${MRPT_USE_LIBS})
ENDIF(MRPT_USE_LIBS)

# ======================================================
# Include directories to add to the user project:
# ======================================================
INCLUDE_DIRECTORIES(${MRPT_CONFIG_DIR})
INCLUDE_DIRECTORIES(${MRPT_SOURCE_DIR}/include)

# OpenCV library:
IF(1)    # CMAKE_MRPT_HAS_OPENCV_SYSTEM
	# Using system opencv lib: 
	# Users must link against OpenCV only if MRPT is not a dynamic library:
	IF (NOT 1)  # CMAKE_MRPT_BUILD_SHARED_LIB
		LINK_DIRECTORIES("")  # OPENCV_LIBDIR
	ENDIF (NOT 1)
ELSE(1)
	INCLUDE_DIRECTORIES("${MRPT_SOURCE_DIR}/include/mrpt/otherlibs/opencv")
ENDIF(1)

# Freeglut in Windows:
IF(MSVC OR BORLAND)
	INCLUDE_DIRECTORIES("${MRPT_SOURCE_DIR}/include/mrpt/otherlibs/glut/")
ENDIF(MSVC OR BORLAND)


# lib3ds library:
IF(0)
	INCLUDE_DIRECTORIES("/include")
	LINK_DIRECTORIES("/lib")
ELSE(0)
	INCLUDE_DIRECTORIES(${MRPT_SOURCE_DIR}/include/mrpt/otherlibs/lib3ds)
ENDIF(0)

# ======================================================
#   MRPT list of libraries the user should link against:
# ======================================================
SET(MRPT_LIBS "")

# We need to process "MRPT_FIND_COMPONENTS" only in GCC: In MSVC/Borland we 
#   use pragmas to add libs to the link.
IF(NOT MSVC AND NOT BORLAND)
	FOREACH(MRPTLIB ${MRPT_FIND_COMPONENTS})
		STRING(TOLOWER ${MRPTLIB} MRPTLIB)
		LIST(APPEND MRPT_LIBS  optimized mrpt-${MRPTLIB}070 debug mrpt-${MRPTLIB}070-dbg)
	ENDFOREACH(MRPTLIB)
	#MESSAGE(STATUS "MRPTConfig: link libs: ${MRPT_LIBS}")
ENDIF(NOT MSVC AND NOT BORLAND)

# ======================================================
# Support for wxWidgets: We only need wx libs at user
#  link time if MRPT libs are static.
# ======================================================
IF(1 AND NOT 1)
	SET(wxWidgets_USE_LIBS base core gl adv aui)

	IF(CMAKE_BUILD_TYPE MATCHES "Debug")
		SET(wxWidgets_USE_DEBUG "ON")
	ELSE(CMAKE_BUILD_TYPE MATCHES "Debug")
		SET(wxWidgets_USE_REL_AND_DBG "ON")
	ENDIF(CMAKE_BUILD_TYPE MATCHES "Debug")

	FIND_PACKAGE(wxWidgets)
	IF(wxWidgets_FOUND)
		# Include wxWidgets macros
		INCLUDE(${wxWidgets_USE_FILE})
		# ${wxWidgets_LIBRARIES}  will contain the libraries that should be added through TARGET_LINK_LIBRARIES(...)
		LINK_DIRECTORIES(${wxWidgets_LIBRARY_DIRS})

		IF(MSVC)
			ADD_DEFINITIONS(-DwxUSE_NO_MANIFEST=1)
		ENDIF(MSVC)

		LIST(APPEND MRPT_LIBS ${wxWidgets_LIBRARIES})
		IF(MSVC)
			ADD_DEFINITIONS(-D_CRT_SECURE_NO_WARNINGS)
		ENDIF(MSVC)
	ELSE(wxWidgets_FOUND)
		MESSAGE("Warning: MRPT was compiled with wxWidgets, but CMake is not able to locate wxWidgets automatically. Please, set wxWidgets_ROOT_DIR to the lib directory manually.\n You can safely ignore this warning if you don't intend to use MRPT GUI classes or wxWidgets directly from your application.")
	ENDIF(wxWidgets_FOUND)
ENDIF(1 AND NOT 1)

# ======================================================
# Support for Bumblebee
# ======================================================
IF(WIN32)
	IF(0)
		INCLUDE_DIRECTORIES("/include")
		INCLUDE_DIRECTORIES("/include")

		LINK_DIRECTORIES("@BUMBLEBEE_DIGICLOPS_ROOT_DIR}/lib@")
		LINK_DIRECTORIES("@BUMBLEBEE_TRICLOPS_ROOT_DIR}/lib@")
	ENDIF(0)
ENDIF(WIN32)

# ======================================================
# Support for VLD
# ======================================================
IF(0)
	INCLUDE_DIRECTORIES("/include")
	LINK_DIRECTORIES("/lib")
ENDIF(0)

# ======================================================
# Link directories to add to the user project:
# ======================================================
LINK_DIRECTORIES(${MRPT_DIR}/lib)
LINK_DIRECTORIES(${MRPT_DIR}/lib/otherlibs)
#LINK_DIRECTORIES(${MRPT_SOURCE_DIR}/lib/otherlibs)


