/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef  CJOYSTICK_H
#define  CJOYSTICK_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/config.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This class can be used to query information and the state of Joysticks in the computer.
	 *
	 *
	 */
	class CJoystick
	{
	private:
		/** The axis limits:
		 */
		int x_min,x_max,y_min,y_max,z_min,z_max;

	public:
		/** Constructor
		 */
		CJoystick();


		/** Returns the number of Joysticks in the computer.
		 */
		static int  getJoysticksCount();

		/** Gets joystick information.
		 *
		 * \param nJoy Can be 1 or 2, selecting the joystick to be read.Default joystick is "1".
		 * \param x The x axis position, range [-1,1]
		 * \param y The y axis position, range [-1,1]
		 * \param z The z axis position, range [-1,1]
		 * \param buttons Each element will hold true if buttons are pressed.Calling must provide a pointer to an existent array of 4 bools
		 * \param raw_x_pos If it is desired the raw integer measurement from JoyStick, set this pointer to a desired placeholder.
		 * \param raw_y_pos If it is desired the raw integer measurement from JoyStick, set this pointer to a desired placeholder.
		 * \param raw_z_pos If it is desired the raw integer measurement from JoyStick, set this pointer to a desired placeholder.
		 *
		 * \return Returns true if successfull, false on error, for example, if joystick is not present.
		 *
		 * \sa setLimits
		 */
		bool  getJoystickPosition( int nJoy , float &x,float &y,float &z, bool buttons[4],int *raw_x_pos=NULL,int	*raw_y_pos=NULL, int *raw_z_pos=NULL );

		/** Set the axis limit values, for computing a [-1,1] position index easily.
		 *   It seems that these values must been calibrated for each joystick model.
		 *
		 * \sa getJoystickPosition
		 */
		void  setLimits( int x_min = 0,int x_max = 0xFFFF, int y_min=0,int y_max = 0xFFFF,int z_min=0,int z_max = 0xFFFF );

	}; // End of class def.

} // End of namespace

#endif
