/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef  CHillClimbing_H
#define  CHillClimbing_H

#include <MRPT/UTILS/CDebugOutputCapable.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This class offers a hill climbing algorithm for a user-supplied functor.
	 * TODO: Explain how this works...
	 * \sa CSerializable
	 */
	class CHillClimbing : public CDebugOutputCapable
	{
	public:
		/** Executes the hill climbing.
		  * \param x0 The initial position for the algorithm (it also states the dimension of the variable "x").
		  * \param functor The user-suplied function to be optimized: functor(x,param)
		  * \param increments A vector with the elemental increments in each dimension of "x" (must be of the same dim)
		  * \param userParam This vector will be passed to the user functor: functor(x,param), where "x" is the variable to be optimized.
		  * \param maxIter The maximum number of iterations to run.
		  * \param findMinimum If set to false (default), the algorithm finds the maximum value. Otherwise it optimizes for the minimum value instead.
		  * \return The resulting maximum value "x" found by the hill climbing.
		  */
		vector_double  execute(
						vector_double				&x0,
						TFunctor_retDbl_inp2VecDbl	functor,
						vector_double				&increments,
						vector_double				&userParam,
						unsigned int				maxIter = 100,
						bool						findMinimum = false);

	}; // End of class def.

} // End of namespace

#endif
