/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef  CDebugOutputCapable_H
#define  CDebugOutputCapable_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/CStdOutStream.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This base class is used just for grouping purposes and for providing a common debug text output.
	  *  See CDebugOutputCapable::printf_debug.
	 */
	class CDebugOutputCapable
	{
	public:

		/** Default initialization:
		  */
		CDebugOutputCapable() : debugOut ( &UTILS::stdOut )
		{
		}

		CDebugOutputCapable(const CDebugOutputCapable&o) : debugOut(o.debugOut) { }
		CDebugOutputCapable & operator =(const CDebugOutputCapable&o) { debugOut = o.debugOut; return *this; }

		virtual ~CDebugOutputCapable() { }

		/** This can be used to output debug messages: default output is the console (through the UTILS::stdOut object), but users can implements any other output, i.e. for GUI applications.
		  * \sa ExampleXXX (TO DO...)
		  */
		CStream		*debugOut;

		/** Sends a formated text to "debugOut" if not NULL, or to cout otherwise.
		  */
		void printf_debug( const char *frmt, ... );

	}; // End of class def.

} // End of namespace

#endif
