/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
/**  This is the main "include file" for classes into the MRML namespace. This file
 *	   includes all the other ones, so user applications must include just this one
 *     and link against the "MRPT.LIB" file.
 */
#ifndef MRVL_H
#define MRVL_H

/** Classes for computer vision, detectors, features, etc.
 */
namespace MRVL
{
	/** You must call MRVL::registerAllClasses() before parsing objects from binary streams of classes
	  *   that are not explicitly used in your application. If it is called more than once, it has no effect.
	  */
	void registerAllClasses();
}

// Classes into MRVL
// --------------------------------------------
#include <MRPT/MRVL/CStereoGrabber_Bumblebee.h>
#include <MRPT/MRVL/CImageGrabber_OpenCV.h>
#include <MRPT/MRVL/VisionUtils.h>
#include <MRPT/MRVL/CStereoImagesTo3D.h>
#include <MRPT/MRVL/CGaussianConvolutionKernel.h>
#include <MRPT/MRVL/CImageConvolution.h>
#include <MRPT/MRVL/CHarrisFeatureDetector.h>
#include <MRPT/MRVL/CCamModel.h>
#include <MRPT/MRVL/CKanadeLucasTomasi.h>
#include <MRPT/MRVL/CVisualOdometryStereo.h>
#include <MRPT/MRVL/CStereoServerBumblebee.h>
#include <MRPT/MRVL/CFeatureExtraction.h>
#include <MRPT/MRVL/CDescriptorComputation.h>

#endif
