// MEM_IO.cpp
// MEM_IO.cpp,v 4.2 2000/02/16 04:58:45 nanbor Exp

#define ACE_BUILD_DLL
#include "ace/MEM_IO.h"
#include "ace/Handle_Set.h"

#if defined (ACE_LACKS_INLINE_FUNCTIONS)
#include "ace/MEM_IO.i"
#endif /* ACE_LACKS_INLINE_FUNCTIONS */

ACE_RCSID(ace, MEM_IO, "MEM_IO.cpp,v 4.2 2000/02/16 04:58:45 nanbor Exp")

ACE_ALLOC_HOOK_DEFINE(ACE_MEM_IO)

void
ACE_MEM_IO::dump (void) const
{
  ACE_TRACE ("ACE_MEM_IO::dump");
}

// Allows a client to read from a socket without having to provide
// a buffer to read.  This method determines how much data is in the
// socket, allocates a buffer of this size, reads in the data, and
// returns the number of bytes read.

ssize_t
ACE_MEM_IO::send (const ACE_Message_Block *message_block,
                  const ACE_Time_Value *timeout)
{
  ACE_TRACE ("ACE_MEM_IO::send");

  ssize_t len = message_block->total_length ();

  if (len != 0)
    {
      char *buf = ACE_static_cast (char *, this->acquire_buffer (len));
      ssize_t n = 0;
      while (message_block != 0)
        {
          ACE_OS::memcpy (buf + n,
                          message_block->rd_ptr (),
                          message_block->length ());
          n += message_block->length ();

          if (message_block->cont ())
            message_block = message_block->cont ();
          else
            message_block = message_block->next ();
        }

      off_t offset = this->set_buf_len (buf, len);
      if (ACE::send (this->get_handle (),
                     (const char *) &offset,
                     sizeof (offset),
                     0,
                     timeout) != sizeof (offset))
        {
          // unsucessful send, release the memory in the shared-memory.
          this->release_buffer (buf);

          return -1;
        }
      return len;
    }
  return 0;
}


#if 0
ssize_t
ACE_MEM_IO::recvv (iovec *io_vec,
                    const ACE_Time_Value *timeout)
{
  ACE_TRACE ("ACE_MEM_IO::recvv");
#if defined (FIONREAD)
  ACE_Handle_Set handle_set;
  handle_set.reset ();
  handle_set.set_bit (this->get_handle ());

  io_vec->iov_base = 0;

  // Check the status of the current socket.
  switch (ACE_OS::select (int (this->get_handle ()) + 1,
                          handle_set,
                          0, 0,
                          timeout))
    {
    case -1:
      return -1;
      /* NOTREACHED */
    case 0:
      errno = ETIME;
      return -1;
      /* NOTREACHED */
    default:
      // Goes fine, fallthrough to get data
      break;
    }

  u_long inlen;

  if (ACE_OS::ioctl (this->get_handle (),
                     FIONREAD,
                     (u_long *) &inlen) == -1)
    return -1;
  else if (inlen > 0)
    {
      ACE_NEW_RETURN (io_vec->iov_base,
                      char[inlen],
                      -1);
      io_vec->iov_len = this->recv (io_vec->iov_base,
                                    inlen);
      return io_vec->iov_len;
    }
  else
    return 0;
#else
  ACE_UNUSED_ARG (io_vec);
  ACE_UNUSED_ARG (timeout);
  ACE_NOTSUP_RETURN (-1);
#endif /* FIONREAD */
}

// Send N char *ptrs and int lengths.  Note that the char *'s precede
// the ints (basically, an varargs version of writev).  The count N is
// the *total* number of trailing arguments, *not* a couple of the
// number of tuple pairs!

ssize_t
ACE_MEM_IO::send (size_t n, ...) const
{
  ACE_TRACE ("ACE_MEM_IO::send");

  va_list argp;
  size_t total_tuples = n / 2;
  iovec *iovp;
#if defined (ACE_HAS_ALLOCA)
  iovp = (iovec *) alloca (total_tuples * sizeof (iovec));
#else
  ACE_NEW_RETURN (iovp,
                  iovec[total_tuples],
                  -1);
#endif /* !defined (ACE_HAS_ALLOCA) */

  va_start (argp, n);

  for (size_t i = 0; i < total_tuples; i++)
    {
      iovp[i].iov_base = va_arg (argp, char *);
      iovp[i].iov_len = va_arg (argp, ssize_t);
    }

  ssize_t result = ACE_OS::sendv (this->get_handle (),
                                  iovp,
                                  total_tuples);
#if !defined (ACE_HAS_ALLOCA)
  delete [] iovp;
#endif /* !defined (ACE_HAS_ALLOCA) */
  va_end (argp);
  return result;
}

// This is basically an interface to ACE_OS::readv, that doesn't use
// the struct iovec_Base explicitly.  The ... can be passed as an arbitrary
// number of (char *ptr, int len) tuples.  However, the count N is the
// *total* number of trailing arguments, *not* a couple of the number
// of tuple pairs!

ssize_t
ACE_MEM_IO::recv (size_t n, ...) const
{
  ACE_TRACE ("ACE_MEM_IO::recv");

  va_list argp;
  size_t total_tuples = n / 2;
  iovec *iovp;
#if defined (ACE_HAS_ALLOCA)
  iovp = (iovec *) alloca (total_tuples * sizeof (iovec));
#else
  ACE_NEW_RETURN (iovp,
                  iovec[total_tuples],
                  -1);
#endif /* !defined (ACE_HAS_ALLOCA) */

  va_start (argp, n);

  for (size_t i = 0; i < total_tuples; i++)
    {
      iovp[i].iov_base = va_arg (argp, char *);
      iovp[i].iov_len = va_arg (argp, ssize_t);
    }

  ssize_t result = ACE_OS::recvv (this->get_handle (),
                                  iovp,
                                  total_tuples);
#if !defined (ACE_HAS_ALLOCA)
  delete [] iovp;
#endif /* !defined (ACE_HAS_ALLOCA) */
  va_end (argp);
  return result;
}
#endif /* 0 */
