/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef MRPT_CONFIG_H
#define MRPT_CONFIG_H

/** If defined, security checks (ASSERT_'s) will be performed in many MRPT classes even 
  *  if "_DEBUG" is not declared, which is then the default behavior.
  */
#define MRPT_ALWAYS_CHECKS_DEBUG 1


/** MRPT_BUILT_AS_DLL is defined only if MRPT has been built 
  *   as a shared library (.dll/.so) vs. a static library (.lib/.a).
  *  Additionally, MRPT_EXPORTS will be defined only when compiling
  *   the DLLs, not when the user import them.
  */
/* #define MRPT_BUILT_AS_DLL */

/** Includes the OpenCV library, required for image manipulation.
  * \sa CImageGrabber_OpenCV
  */
#define MRPT_HAS_OPENCV  1

/** Includes OpenGL & GLUT libraries, required for CDisplayWindows3D to work.
  */
#define MRPT_HAS_OPENGL_GLUT 1

/** Define for including Bumblebee interface through the vendor's proprietary API, which enables the definition of some classes in the MRVL namespace.
  * \sa CStereoGrabber_Bumblebee
  */
#define MRPT_HAS_BUMBLEBEE 0

/** The file ftdi.h exists (Linux only)
  */
#define MRPT_HAS_FTDI 1

/** wxWidgets is present in the system (required for UTILS::CDisplayWindow, etc.)
  */
#define MRPT_HAS_WXWIDGETS 1

/** For Windows and Debug config. only, whether to include the Visual Leak Detector:
  */
#define MRPT_HAS_VLD 0

#if defined(_WIN32) || defined(_WIN32_)  || defined(WIN32) || defined(_WIN64)
    #define MRPT_OS_WINDOWS
#else
#if defined(unix) || defined(__unix__) || defined(__unix)
    #define MRPT_OS_LINUX
#else
    #error Unsupported platform (Found neither _WIN32_ nor __unix__)
#endif
#endif

/** The size of cells in MRML::COccupancyGridMap2D
  */
#define	OCCUPANCY_GRIDMAP_CELL_SIZE_8BITS


/** Set to 0 to disable MRPT_TRY_START/MRPT_TRY_END blocks. Not recommended but for intensively tested programs only.
  */
#define MRPT_HAS_STACKED_EXCEPTIONS 1

/** Enable Katakana, Hiragana & Kanji character sets in UTILS::CMRPTCanvas.
  *  Disable this to save executable sizes if these fonts will be not used.
  */
#define MRPT_HAS_ASIAN_FONTS 1

/** Set to 0 to disable ASSERT_ statements. Not recommended but for intensively tested programs only.
  */
#define MRPT_HAS_ASSERT 1

#if defined(_MSC_VER) && (_MSC_VER>=1300)
	/** Define this symbol if the target processor supports the SSE machine instructions set
	*/
	#define MRPT_HAS_SSE
#endif

// -------------------------------
//			Some checks:
// -------------------------------
#if defined(MRPT_OS_WINDOWS) && defined(MRPT_OS_LINUX)
#error You cannot define both MRPT_OS_LINUX and MRPT_OS_WINDOWS!
#endif
#if !defined(MRPT_OS_WINDOWS) && !defined(MRPT_OS_LINUX)
#error You must define either MRPT_OS_LINUX or MRPT_OS_WINDOWS!
#endif


#endif

