/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef  ZipCompression_H
#define  ZipCompression_H

#include <MRPT/UTILS/utils_defs.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	class CStream;

	/** This class groups static methods allowing easy ZIP compression/decompression.
	 */
	namespace ZipCompression
	{
		/** Compress an array of bytes into another one.
		  */
		void  compress(
			void						*inData,
			size_t						inDataSize,
			std::vector<unsigned char>	&outData);

		/** Compress an array of bytes into another one.
		  */
		void  compress(
			const std::vector<unsigned char>	&inData,
			std::vector<unsigned char>			&outData);

		/** Compress an array of bytes and write the result into a stream.
		  */
		void  compress(
			void						*inData,
			size_t						inDataSize,
			CStream						&out);

		/** Compress an array of bytes and write the result into a stream.
		  */
		void  compress(
			const std::vector<unsigned char>	&inData,
			CStream								&out);

		/** Decompress an array of bytes into another one
		  * \exception std::exception If the apriori estimated decompressed size is not enought
		  */
		void  decompress(
			void						*inData,
			size_t						inDataSize,
			std::vector<unsigned char>	&outData,
			size_t						outDataEstimatedSize);

		/** Decompress an array of bytes into another one
		  * \exception std::exception If the apriori estimated decompressed size is not enought
		  */
		void  decompress(
			void						*inData,
			size_t						inDataSize,
			void						*outData,
			size_t						outDataBufferSize,
			size_t						&outDataActualSize);

		/** Decompress an array of bytes into another one
		  * \exception std::exception If the apriori estimated decompressed size is not enought
		  */
		void  decompress(
			CStream						&inStream,
			size_t						inDataSize,
			void						*outData,
			size_t						outDataBufferSize,
			size_t						&outDataActualSize);

	} // End of class def.

} // End of namespace

#endif
