/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CImageGrabber_OpenCV_H
#define CImageGrabber_OpenCV_H

#include <MRPT/config.h>

#include <MRPT/MRML/CObservationImage.h>

#include <MRPT/OTHERLIBS/OPENCV/highgui.h>

namespace MRVL
{

	/** A class for grabing images from a "OpenCV"-compatible camera, or from an AVI video file.
	  * NOTE:
	  *		- This class is only available when compiling MRPT with the flag "MRPT_HAS_OPENCV" defined.
	  */
	class CImageGrabber_OpenCV
	{
	protected:
		/** Set to false if we could not initialize the camera.
		  */
		bool	m_bInitialized;

		/** Internal use:
		  */
		CvCapture *m_capture;

	public:
		/** Constructor for cameras:
		 * \param cameraIndex Set the camera index, or -1 if it does not matter
		*/
		CImageGrabber_OpenCV( int cameraIndex = -1 );

		/** Constructor for AVI files:
		*/
		CImageGrabber_OpenCV( const char *AVI_fileName );

		/** Destructor
		*/
		virtual ~CImageGrabber_OpenCV( );

		/** Grab an image from the opened camera.
		 * \param out_observation The object to be filled with sensed data.
		 *
		 * \return false on any error, true if all go fine.
		*/
		bool  getObservation( MRML::CObservationImage &out_observation);


	};	// End of class

} // End of NS


#endif
