/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CAction_H
#define CAction_H

#include <MRPT/UTILS/CSerializable.h>
#include <MRPT/UTILS/SystemUtils.h>

namespace MRML
{
	/** Declares a class for storing a robot action. It is used in MRML::CActionObservationSequence,
	 *    for logs storage and particle filter based simulations.
	 *  See derived classes for implementations.
     *
	 * \sa CActionCollection, CActionObservationSequence
	 */
	class CAction : public UTILS::CSerializable
	{
		// This must be added to any CSerializable derived class:
		DEFINE_VIRTUAL_SERIALIZABLE( CAction )

		/** Default constructor
  		  */
		CAction();

		/** Constructor
  		  */
		virtual ~CAction();

		 /** The associated time-stamp.
		   *  This was added at 2-Dec-2007, new serialization versions have been added to derived classes to manage this time-stamp.
		   *  Prior versions will be read as having a INVALID_TIMESTAMP value.
		  */
		UTILS::TTimeStamp	timestamp;

	}; // End of class def.

	// This must be added to any CSerializable derived class:
	DEFINE_SERIALIZABLE_POST( CAction )

} // End of namespace

#endif
