@ECHO OFF
REM ------------------------------------------------------------------
REM   BABEL batch script for fully automated building of ICE files 
REM   From any directory, invoke as:
REM 
REM    BABEL_batch_build <BABEL_ROOT> <GENERATOR> <ICEFILE1> <ICENAME1> [<ICEFILE2> <ICENAME2> ...]
REM   
REM   Notes:
REM    - BABEL_ROOT is the main BABEL directory, containing babel_generator.exe
REM 
REM    - ICEFILE's can be absolute paths or relative to BABEL_ROOT
REM
REM    - ICENAME's must match the "module name" (it MAY be different than the ICE file)
REM 
REM    - The order of the ICE files is important: For each module, the IDL
REM       files of all the previous ones are used (i.e. put ICEs in 
REM       the order "dependency", "dependent")
REM 
REM    - All the modules are built in "BUILDDIR" (see below), and at 
REM       the end a Windows Explorer is opened there.
REM 
REM    - All the .ini/.png files attached as "externals" to ICEs are also copied 
REM        to the corresponding "Release" directories.
REM 
REM    - A .bsq sequence file will be also generated for Execution Manager with the list of all modules.
REM 
REM TODO: 
REM   * babel_generator.exe: Add flag "-nokeyatend" ???
REM   * babel_generator.exe: Add flag "-direxternals" to dump externals directly in Release???
REM 
REM 
REM   J.L. Blanco - 2009 
REM    MAPIR Lab                   http://babel.isa.uma.es/babel2/
REM ------------------------------------------------------------------

REM "BUILDDIR": Where the modules will be built
REM   It can ONLY contain ASCII chars (due to a problem with ACE-TAO)
REM -----------------------------------------------------------------
REM set BUILDDIR=%TMP%\BUILD
set BUILDDIR=%HOMEDRIVE%\babel_modules_build

set BABELDIR=%1
set BABELGEN=%2
set OLDDIR=%CD%
set BSQFILE=%BUILDDIR%\EM_SEQUENCE.bsq

REM --------------------------------------
REM    Check correct BABEL_ROOT
REM --------------------------------------
if EXIST "%BABELDIR%/babel_generator.exe" goto ok1
echo.
echo ******          DO NOT CALL THIS SCRIPT MANUALLY           *******
echo ****** It's intended to be called by BABEL developers only *******
echo.
echo ERROR. Usage:
echo "  %0 <BABEL_ROOT> <GENERATOR> <ICE1> <NAME1> [<ICE2> <NAME2>...]"
echo.
goto errorend

:ok1
REM - Just for the case BABELDIR is ".", replace by its real value:
chdir /D "%BABELDIR%"
set BABELDIR=%CD%

REM -----------------------------------------------
REM - Start with an empty, fresh build directory:
REM -----------------------------------------------
REM rmdir /S /Q %BUILDDIR% 2> NUL
mkdir %BUILDDIR%
mkdir %BUILDDIR%\IDLS

REM - Create a dummy file just to emulate a key input at the end of babel_generator.exe
set DUMMYFILE=%TMP%\dumm.txt
echo "1" > %DUMMYFILE%
echo. >> %DUMMYFILE%

shift
shift

REM - Start an empty BSQ file:
del %BSQFILE% 2> NUL
set MODULE_COUNTER=0


REM --------------------------------------
REM - For each ICE MODULE:
REM --------------------------------------
:foreach_ice_loop
if "%1"=="" goto all_ices_done

chdir /D "%BABELDIR%"
set ICEFILE=%1
set MODNAME=%2

REM - Check if ICE really exists
if EXIST %ICEFILE% goto ok2
echo ERROR: ICE file does not exist: %ICEFILE%
goto errorend
:ok2

mkdir "%BUILDDIR%\%MODNAME%_build" 2> NUL
babel_generator.exe -ice "%ICEFILE%" -generator %BABELGEN% -target "%BUILDDIR%\%MODNAME%_build"  < %DUMMYFILE%
if not errorlevel 1 goto buildok1
echo ERROR: Running babel_generator.exe for module %MODNAME%
goto errorend

:buildok1
copy /Y "%BUILDDIR%\%MODNAME%_build\*.idl" "%BUILDDIR%\IDLS" >NUL 2> NUL
copy /Y "%BUILDDIR%\IDLS\*.idl" "%BUILDDIR%\%MODNAME%_build\" >NUL 2> NUL
chdir /D "%BUILDDIR%\%MODNAME%_build"

REM - Compile the module, depending on the BABEL generator:
if "%BABELGEN%"=="Endymion" goto compile_msvc9
if "%BABELGEN%"=="Hyperion" goto compile_msvc6
goto compiledone

:compile_msvc6
msdev "ICE_%MODNAME%_workspace.dsw" /MAKE "ICE_%MODNAME%_project - Win32 Release"
goto compiledone

:compile_msvc9
devenv "%MODNAME%_Project.sln" /build Release
goto compiledone


:compiledone
if not errorlevel 1 goto buildok2
echo ERROR: Compiling module %MODNAME%
goto errorend

:buildok2

REM - Copy any extra files
copy /Y "%BUILDDIR%\%MODNAME%_build\*.ini" "%BUILDDIR%\%MODNAME%_build\Release\" >NUL 2> NUL
copy /Y "%BUILDDIR%\%MODNAME%_build\*.png" "%BUILDDIR%\%MODNAME%_build\Release\" >NUL 2> NUL
copy /Y "%BUILDDIR%\%MODNAME%_build\*.bmp" "%BUILDDIR%\%MODNAME%_build\Release\" >NUL 2> NUL

REM - Add an entry to the BSQ file:
echo %MODULE_COUNTER% [%MODNAME%.exe][%BUILDDIR%\%MODNAME%_build\Release\][^<local^>][-RemoteMandatory][1][-1][] >> %BSQFILE%
set /A MODULE_COUNTER+=1

REM - Go on with the next module
shift
shift
goto foreach_ice_loop


REM --------------------------------------
REM - ALL MODULES BUILT OK
REM --------------------------------------
:all_ices_done
echo.
echo === All done OK
echo.
goto end


:errorend
pause
chdir /D %OLDDIR%
exit /b -1

:end
explorer %BUILDDIR%
chdir /D %OLDDIR%

